/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRelModel;
import com.liferay.account.service.AccountGroupRelLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.account.model.AccountGroup"}, service={ModelDocumentContributor.class})
public class AccountGroupModelDocumentContributor
implements ModelDocumentContributor<AccountGroup> {
    @Reference
    private AccountGroupRelLocalService _accountGroupRelLocalService;

    public void contribute(Document document, AccountGroup accountGroup) {
        document.addText("description", accountGroup.getDescription());
        document.addText("name", accountGroup.getName());
        document.addKeyword("type", accountGroup.getType());
        document.addKeyword("accountEntryIds", this._getAccountEntryIds(accountGroup));
        document.addKeyword("defaultAccountGroup", accountGroup.isDefaultAccountGroup());
        document.remove("userName");
    }

    private Long[] _getAccountEntryIds(AccountGroup accountGroup) {
        return (Long[])TransformUtil.transformToArray((Collection)this._accountGroupRelLocalService.getAccountGroupRels(accountGroup.getAccountGroupId(), AccountEntry.class.getName()), AccountGroupRelModel::getClassPK, Long.class);
    }
}

