/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.exception.DefaultAccountGroupException;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.util.PortalInstances;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class AccountGroupModelListener
extends BaseModelListener<AccountGroup> {
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;

    public void onAfterRemove(AccountGroup accountGroup) {
        if (PortalInstances.isCurrentCompanyInDeletionProcess()) {
            return;
        }
        if (accountGroup.isDefaultAccountGroup()) {
            throw new ModelListenerException((Throwable)new DefaultAccountGroupException.MustNotDeleteDefaultAccountGroup(accountGroup.getAccountGroupId()));
        }
    }

    public void onBeforeCreate(AccountGroup accountGroup) throws ModelListenerException {
        if (accountGroup.isDefaultAccountGroup() && this._accountGroupLocalService.hasDefaultAccountGroup(accountGroup.getCompanyId())) {
            throw new ModelListenerException((Throwable)new DefaultAccountGroupException.MustNotDuplicateDefaultAccountGroup(accountGroup.getCompanyId()));
        }
    }

    public void onBeforeUpdate(AccountGroup originalAccountGroup, AccountGroup accountGroup) throws ModelListenerException {
        if (accountGroup.isDefaultAccountGroup()) {
            throw new ModelListenerException((Throwable)new DefaultAccountGroupException.MustNotUpdateDefaultAccountGroup(accountGroup.getAccountGroupId()));
        }
    }
}

