/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountGroupRelLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class AccountEntryModelListener
extends BaseModelListener<AccountEntry> {
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private AccountGroupRelLocalService _accountGroupRelLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;

    public void onAfterRemove(AccountEntry accountEntry) throws ModelListenerException {
        List accountGroupRels = this._accountGroupRelLocalService.getAccountGroupRels(AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        for (Object accountGroupRel : accountGroupRels) {
            this._accountGroupRelLocalService.deleteAccountGroupRel((AccountGroupRel)accountGroupRel);
        }
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId());
        for (Object accountEntryOrganizationRel : accountEntryOrganizationRels) {
            this._accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRel((AccountEntryOrganizationRel)accountEntryOrganizationRel);
        }
        List accountRoles = this._accountRoleLocalService.getAccountRolesByAccountEntryIds(new long[]{accountEntry.getAccountEntryId()});
        try {
            for (AccountRole accountRole : accountRoles) {
                this._accountRoleLocalService.deleteAccountRole(accountRole);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
        List accountEntryUserRels = this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntry.getAccountEntryId());
        for (AccountEntryUserRel accountEntryUserRel : accountEntryUserRels) {
            this._accountEntryUserRelLocalService.deleteAccountEntryUserRel(accountEntryUserRel);
        }
    }

    public void onAfterUpdate(AccountEntry originalAccountEntry, AccountEntry accountEntry) {
        this._reindexAccountEntry(accountEntry);
    }

    private void _reindexAccountEntry(AccountEntry accountEntry) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AccountEntry.class);
            indexer.reindex((Object)accountEntry);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }
}

