/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.configuration.persistence.listener;

import com.liferay.account.configuration.AccountEntryEmailDomainsConfiguration;
import com.liferay.account.internal.validator.util.DomainValidatorFactoryUtil;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import org.apache.commons.validator.routines.DomainValidator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.configuration.AccountEntryEmailDomainsConfiguration"}, service={ConfigurationModelListener.class})
public class AccountEntryEmailDomainsConfigurationModelListener
implements ConfigurationModelListener {
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private Language _language;

    public void onAfterSave(String pid, Dictionary<String, Object> properties) {
        long companyId = this._getCompanyId(properties);
        if (companyId == 0L) {
            return;
        }
        Object[] blockedEmailAddressDomains = this._getBlockedEmailAddressDomains(properties);
        if (ArrayUtil.isEmpty((Object[])blockedEmailAddressDomains)) {
            return;
        }
        BaseModelSearchResult baseModelSearchResult = this._accountEntryLocalService.searchAccountEntries(companyId, null, new LinkedHashMap<String, Object[]>(Collections.singletonMap("domains", blockedEmailAddressDomains)), -1, -1, null, false);
        for (AccountEntry accountEntry : baseModelSearchResult.getBaseModels()) {
            Object[] domains = accountEntry.getDomainsArray();
            for (Object blockedEmailAddressDomain : blockedEmailAddressDomains) {
                domains = ArrayUtil.remove((String[])domains, (String)blockedEmailAddressDomain);
            }
            accountEntry.setDomains(StringUtil.merge((Object[])domains));
            this._accountEntryLocalService.updateAccountEntry(accountEntry);
        }
    }

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        if (this._getCompanyId(properties) == 0L) {
            return;
        }
        Object[] blockedEmailAddressDomains = this._getBlockedEmailAddressDomains(properties);
        if (ArrayUtil.isEmpty((Object[])blockedEmailAddressDomains)) {
            return;
        }
        Arrays.setAll(blockedEmailAddressDomains, arg_0 -> AccountEntryEmailDomainsConfigurationModelListener.lambda$onBeforeSave$0((String[])blockedEmailAddressDomains, arg_0));
        DomainValidator domainValidator = DomainValidatorFactoryUtil.create(GetterUtil.getStringValues((Object)properties.get("customTLDs"), (String[])_EMPTY_STRING_ARRAY));
        ArrayList<Object> invalidDomains = new ArrayList<Object>();
        for (Object blockedEmailAddressDomain : blockedEmailAddressDomains) {
            if (domainValidator.isValid((String)blockedEmailAddressDomain)) continue;
            invalidDomains.add(blockedEmailAddressDomain);
        }
        if (ListUtil.isNotEmpty(invalidDomains)) {
            throw new ConfigurationModelListenerException(this._language.format(LocaleThreadLocal.getSiteDefaultLocale(), "these-domains-are-not-formatted-correctly-x", (Object)StringUtil.merge(invalidDomains, (String)", ")), AccountEntryEmailDomainsConfiguration.class, AccountEntryEmailDomainsConfigurationModelListener.class, (Dictionary)HashMapDictionaryBuilder.put((Object)"invalidDomains", (Object)ArrayUtil.toStringArray(invalidDomains)).build());
        }
        properties.put("blockedEmailDomains", StringUtil.merge((Object[])blockedEmailAddressDomains, (String)"\n"));
    }

    private String[] _getBlockedEmailAddressDomains(Dictionary<String, Object> properties) {
        return StringUtil.split((String)GetterUtil.getString((Object)properties.get("blockedEmailDomains")), (char)'\n');
    }

    private long _getCompanyId(Dictionary<String, Object> properties) {
        return GetterUtil.getLong((Object)properties.get("companyId"), (long)0L);
    }

    private static /* synthetic */ String lambda$onBeforeSave$0(String[] blockedEmailAddressDomains, int i) {
        return StringUtil.lowerCase((String)StringUtil.trim((String)blockedEmailAddressDomains[i]));
    }
}

