/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.account.model.impl;

import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.model.AccountEntryUserRelModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the AccountEntryUserRel service. Represents a row in the &quot;AccountEntryUserRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AccountEntryUserRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AccountEntryUserRelImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountEntryUserRelImpl
 * @generated
 */
@JSON(strict = true)
public class AccountEntryUserRelModelImpl
	extends BaseModelImpl<AccountEntryUserRel>
	implements AccountEntryUserRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a account entry user rel model instance should use the <code>AccountEntryUserRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "AccountEntryUserRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"accountEntryUserRelId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"accountEntryId", Types.BIGINT},
		{"accountUserId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("accountEntryUserRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("accountEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("accountUserId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table AccountEntryUserRel (mvccVersion LONG default 0 not null,accountEntryUserRelId LONG not null primary key,companyId LONG,accountEntryId LONG,accountUserId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table AccountEntryUserRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY accountEntryUserRel.accountEntryUserRelId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY AccountEntryUserRel.accountEntryUserRelId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACCOUNTENTRYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACCOUNTUSERID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACCOUNTENTRYUSERRELID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public AccountEntryUserRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _accountEntryUserRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setAccountEntryUserRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _accountEntryUserRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return AccountEntryUserRel.class;
	}

	@Override
	public String getModelClassName() {
		return AccountEntryUserRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<AccountEntryUserRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<AccountEntryUserRel, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AccountEntryUserRel, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((AccountEntryUserRel)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<AccountEntryUserRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<AccountEntryUserRel, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(AccountEntryUserRel)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<AccountEntryUserRel, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<AccountEntryUserRel, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<AccountEntryUserRel, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<AccountEntryUserRel, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<AccountEntryUserRel, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", AccountEntryUserRel::getMvccVersion);
			attributeGetterFunctions.put(
				"accountEntryUserRelId",
				AccountEntryUserRel::getAccountEntryUserRelId);
			attributeGetterFunctions.put(
				"companyId", AccountEntryUserRel::getCompanyId);
			attributeGetterFunctions.put(
				"accountEntryId", AccountEntryUserRel::getAccountEntryId);
			attributeGetterFunctions.put(
				"accountUserId", AccountEntryUserRel::getAccountUserId);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<AccountEntryUserRel, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<AccountEntryUserRel, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<AccountEntryUserRel, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<AccountEntryUserRel, Long>)
					AccountEntryUserRel::setMvccVersion);
			attributeSetterBiConsumers.put(
				"accountEntryUserRelId",
				(BiConsumer<AccountEntryUserRel, Long>)
					AccountEntryUserRel::setAccountEntryUserRelId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<AccountEntryUserRel, Long>)
					AccountEntryUserRel::setCompanyId);
			attributeSetterBiConsumers.put(
				"accountEntryId",
				(BiConsumer<AccountEntryUserRel, Long>)
					AccountEntryUserRel::setAccountEntryId);
			attributeSetterBiConsumers.put(
				"accountUserId",
				(BiConsumer<AccountEntryUserRel, Long>)
					AccountEntryUserRel::setAccountUserId);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getAccountEntryUserRelId() {
		return _accountEntryUserRelId;
	}

	@Override
	public void setAccountEntryUserRelId(long accountEntryUserRelId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_accountEntryUserRelId = accountEntryUserRelId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getAccountEntryId() {
		return _accountEntryId;
	}

	@Override
	public void setAccountEntryId(long accountEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_accountEntryId = accountEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalAccountEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("accountEntryId"));
	}

	@JSON
	@Override
	public long getAccountUserId() {
		return _accountUserId;
	}

	@Override
	public void setAccountUserId(long accountUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_accountUserId = accountUserId;
	}

	@Override
	public String getAccountUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getAccountUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setAccountUserUuid(String accountUserUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalAccountUserId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("accountUserId"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), AccountEntryUserRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public AccountEntryUserRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, AccountEntryUserRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AccountEntryUserRelImpl accountEntryUserRelImpl =
			new AccountEntryUserRelImpl();

		accountEntryUserRelImpl.setMvccVersion(getMvccVersion());
		accountEntryUserRelImpl.setAccountEntryUserRelId(
			getAccountEntryUserRelId());
		accountEntryUserRelImpl.setCompanyId(getCompanyId());
		accountEntryUserRelImpl.setAccountEntryId(getAccountEntryId());
		accountEntryUserRelImpl.setAccountUserId(getAccountUserId());

		accountEntryUserRelImpl.resetOriginalValues();

		return accountEntryUserRelImpl;
	}

	@Override
	public AccountEntryUserRel cloneWithOriginalValues() {
		AccountEntryUserRelImpl accountEntryUserRelImpl =
			new AccountEntryUserRelImpl();

		accountEntryUserRelImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		accountEntryUserRelImpl.setAccountEntryUserRelId(
			this.<Long>getColumnOriginalValue("accountEntryUserRelId"));
		accountEntryUserRelImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		accountEntryUserRelImpl.setAccountEntryId(
			this.<Long>getColumnOriginalValue("accountEntryId"));
		accountEntryUserRelImpl.setAccountUserId(
			this.<Long>getColumnOriginalValue("accountUserId"));

		return accountEntryUserRelImpl;
	}

	@Override
	public int compareTo(AccountEntryUserRel accountEntryUserRel) {
		long primaryKey = accountEntryUserRel.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof AccountEntryUserRel)) {
			return false;
		}

		AccountEntryUserRel accountEntryUserRel = (AccountEntryUserRel)object;

		long primaryKey = accountEntryUserRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<AccountEntryUserRel> toCacheModel() {
		AccountEntryUserRelCacheModel accountEntryUserRelCacheModel =
			new AccountEntryUserRelCacheModel();

		accountEntryUserRelCacheModel.mvccVersion = getMvccVersion();

		accountEntryUserRelCacheModel.accountEntryUserRelId =
			getAccountEntryUserRelId();

		accountEntryUserRelCacheModel.companyId = getCompanyId();

		accountEntryUserRelCacheModel.accountEntryId = getAccountEntryId();

		accountEntryUserRelCacheModel.accountUserId = getAccountUserId();

		return accountEntryUserRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<AccountEntryUserRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<AccountEntryUserRel, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AccountEntryUserRel, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(AccountEntryUserRel)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, AccountEntryUserRel>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					AccountEntryUserRel.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _accountEntryUserRelId;
	private long _companyId;
	private long _accountEntryId;
	private long _accountUserId;

	public <T> T getColumnValue(String columnName) {
		Function<AccountEntryUserRel, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((AccountEntryUserRel)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"accountEntryUserRelId", _accountEntryUserRelId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("accountEntryId", _accountEntryId);
		_columnOriginalValues.put("accountUserId", _accountUserId);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("accountEntryUserRelId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("accountEntryId", 8L);

		columnBitmasks.put("accountUserId", 16L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private AccountEntryUserRel _escapedModel;

}