/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.base.AccountGroupServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountGroup"}, service={AopService.class})
public class AccountGroupServiceImpl
extends AccountGroupServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountGroup)")
    private ModelResourcePermission<AccountGroup> _accountGroupModelResourcePermission;

    public AccountGroup addAccountGroup(String externalReferenceCode, long userId, String description, String name, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ACCOUNT_GROUP");
        return this.accountGroupLocalService.addAccountGroup(externalReferenceCode, userId, description, name, serviceContext);
    }

    public AccountGroup deleteAccountGroup(long accountGroupId) throws PortalException {
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "DELETE");
        return this.accountGroupLocalService.deleteAccountGroup(accountGroupId);
    }

    public void deleteAccountGroups(long[] accountGroupIds) throws PortalException {
        for (long accountGroupId : accountGroupIds) {
            this.deleteAccountGroup(accountGroupId);
        }
    }

    public AccountGroup fetchAccountGroup(long accountGroupId) throws PortalException {
        AccountGroup accountGroup = this.accountGroupLocalService.fetchAccountGroup(accountGroupId);
        if (accountGroup != null) {
            this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountGroup, "VIEW");
        }
        return accountGroup;
    }

    public AccountGroup fetchAccountGroupByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        AccountGroup accountGroup = this.accountGroupLocalService.fetchAccountGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (accountGroup != null) {
            this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountGroup, "VIEW");
        }
        return accountGroup;
    }

    public AccountGroup getAccountGroup(long accountGroupId) throws PortalException {
        AccountGroup accountGroup = this.accountGroupLocalService.getAccountGroup(accountGroupId);
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountGroup, "VIEW");
        return accountGroup;
    }

    public AccountGroup getAccountGroupByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        AccountGroup accountGroup = this.accountGroupLocalService.getAccountGroupByExternalReferenceCode(externalReferenceCode, companyId);
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountGroup, "VIEW");
        return accountGroup;
    }

    public List<AccountGroup> getAccountGroupsByAccountEntryId(long accountEntryId, int start, int end) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_ACCOUNT_GROUPS");
        return this.accountGroupLocalService.getAccountGroupsByAccountEntryId(accountEntryId, start, end);
    }

    public int getAccountGroupsCountByAccountEntryId(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_ACCOUNT_GROUPS");
        return this.accountGroupLocalService.getAccountGroupsCountByAccountEntryId(accountEntryId);
    }

    public AccountGroup getOrAddIncompleteAccountGroup(String externalReferenceCode, String name) throws Exception {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        AccountGroup accountGroup = this.fetchAccountGroupByExternalReferenceCode(externalReferenceCode, permissionChecker.getCompanyId());
        if (accountGroup != null) {
            return accountGroup;
        }
        PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"ADD_ACCOUNT_GROUP");
        return this.accountGroupLocalService.getOrAddIncompleteAccountGroup(externalReferenceCode, permissionChecker.getCompanyId(), permissionChecker.getUserId(), name);
    }

    public BaseModelSearchResult<AccountGroup> searchAccountGroups(long companyId, String keywords, int start, int end, OrderByComparator<AccountGroup> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        return this.accountGroupLocalService.searchAccountGroups(companyId, keywords, LinkedHashMapBuilder.put((Object)"permissionUserId", (Object)permissionChecker.getUserId()).build(), start, end, orderByComparator);
    }

    public AccountGroup updateAccountGroup(String externalReferenceCode, long accountGroupId, String description, String name, ServiceContext serviceContext) throws PortalException {
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "UPDATE");
        return this.accountGroupLocalService.updateAccountGroup(externalReferenceCode, accountGroupId, description, name, serviceContext);
    }

    public AccountGroup updateExternalReferenceCode(long accountGroupId, String externalReferenceCode) throws PortalException {
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "UPDATE");
        return this.accountGroupLocalService.updateExternalReferenceCode(accountGroupId, externalReferenceCode);
    }
}

