/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.base.AccountEntryOrganizationRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountEntryOrganizationRel"}, service={AopService.class})
public class AccountEntryOrganizationRelServiceImpl
extends AccountEntryOrganizationRelServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;

    public AccountEntryOrganizationRel addAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        return this.accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRel(accountEntryId, organizationId);
    }

    public void addAccountEntryOrganizationRels(long accountEntryId, long[] organizationIds) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        this.accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRels(accountEntryId, organizationIds);
    }

    public void deleteAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        this.accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRel(accountEntryId, organizationId);
    }

    public void deleteAccountEntryOrganizationRels(long accountEntryId, long[] organizationIds) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        this.accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRels(accountEntryId, organizationIds);
    }

    public AccountEntryOrganizationRel fetchAccountEntryOrganizationRel(long accountEntryOrganizationRelId) throws PortalException {
        AccountEntryOrganizationRel accountEntryOrganizationRel = this.accountEntryOrganizationRelLocalService.fetchAccountEntryOrganizationRel(accountEntryOrganizationRelId);
        if (accountEntryOrganizationRel != null) {
            this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryOrganizationRel.getAccountEntryId(), "VIEW_ORGANIZATIONS");
        }
        return accountEntryOrganizationRel;
    }

    public AccountEntryOrganizationRel fetchAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        AccountEntryOrganizationRel accountEntryOrganizationRel = this.accountEntryOrganizationRelLocalService.fetchAccountEntryOrganizationRel(accountEntryId, organizationId);
        if (accountEntryOrganizationRel != null) {
            this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryOrganizationRel.getAccountEntryId(), "UPDATE_ORGANIZATIONS");
        }
        return accountEntryOrganizationRel;
    }

    public AccountEntryOrganizationRel getAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        return this.accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRel(accountEntryId, organizationId);
    }

    public List<AccountEntryOrganizationRel> getAccountEntryOrganizationRels(long accountEntryId, int start, int end) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        return this.accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId, start, end);
    }

    public int getAccountEntryOrganizationRelsCount(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE_ORGANIZATIONS");
        return this.accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRelsCount(accountEntryId);
    }
}

