/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.Organization"}, service={ModelDocumentContributor.class})
public class OrganizationModelDocumentContributor
implements ModelDocumentContributor<Organization> {
    @Reference
    protected AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService;
    private static final Log _log = LogFactoryUtil.getLog(OrganizationModelDocumentContributor.class);

    public void contribute(Document document, Organization organization) {
        block3: {
            try {
                long[] accountEntryIds = this.getAccountEntryIds(organization);
                if (ArrayUtil.isNotEmpty((long[])accountEntryIds)) {
                    document.addKeyword("accountEntryIds", accountEntryIds);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to index organization " + organization.getOrganizationId()), (Throwable)exception);
            }
        }
    }

    protected long[] getAccountEntryIds(Organization organization) {
        DynamicQuery dynamicQuery = this.accountEntryOrganizationRelLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"organizationId", (Object)organization.getOrganizationId()));
        dynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"accountEntryId"));
        return ArrayUtil.toLongArray((Collection)this.accountEntryOrganizationRelLocalService.dynamicQuery(dynamicQuery));
    }
}

