/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountRole;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.account.model.AccountRole"}, service={ModelDocumentContributor.class})
public class AccountRoleModelDocumentContributor
implements ModelDocumentContributor<AccountRole> {
    private static final Log _log = LogFactoryUtil.getLog(AccountRoleModelDocumentContributor.class);

    public void contribute(Document document, AccountRole accountRole) {
        Role role;
        try {
            role = accountRole.getRole();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return;
        }
        document.addKeyword("companyId", accountRole.getCompanyId());
        document.addLocalizedText("description", role.getDescriptionMap());
        document.addText("name", role.getName());
        document.addLocalizedText("title", role.getTitleMap());
        document.addKeyword("accountEntryId", accountRole.getAccountEntryId());
    }
}

