/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.instance.lifecycle;

import com.liferay.account.constants.AccountRoleConstants;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=300"}, service={PortalInstanceLifecycleListener.class})
public class AddDefaultAccountRolesPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Map<String, String[]> _accountAdministratorResourceActionsMap = HashMapBuilder.put((Object)AccountEntry.class.getName(), (Object)new String[]{"UPDATE", "MANAGE_USERS", "MANAGE_ADDRESSES", "VIEW_ADDRESSES", "VIEW_ACCOUNT_ROLES", "VIEW_ORGANIZATIONS", "VIEW_USERS"}).put((Object)AccountRole.class.getName(), (Object)new String[]{"VIEW"}).build();
    private static final Map<String, String[]> _accountManagerResourceActionsMap = HashMapBuilder.put((Object)AccountEntry.class.getName(), (Object)new String[]{"MANAGE_ADDRESSES", "VIEW_ACCOUNT_ROLES", "VIEW_ADDRESSES", "VIEW_ORGANIZATIONS", "VIEW_USERS", "MANAGE_USERS", "UPDATE"}).put((Object)AccountRole.class.getName(), (Object)new String[]{"VIEW"}).put((Object)Organization.class.getName(), (Object)new String[]{"MANAGE_ACCOUNTS", "MANAGE_SUBORGANIZATIONS_ACCOUNTS"}).build();
    private static final Map<String, String[]> _accountMemberResourceActionsMap = HashMapBuilder.put((Object)AccountEntry.class.getName(), (Object)new String[]{"VIEW"}).build();
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.account.service)(&(release.schema.version>=1.0.2)))")
    private Release _release;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (this._checkAccountRole(company, "Account Administrator")) {
            this._checkResourcePermissions(company.getCompanyId(), "Account Administrator", _accountAdministratorResourceActionsMap, _accountMemberResourceActionsMap);
        }
        if (this._checkRole(company, "Account Manager")) {
            this._checkResourcePermissions(company.getCompanyId(), "Account Manager", _accountManagerResourceActionsMap, _accountMemberResourceActionsMap);
        }
        if (this._checkAccountRole(company, "Account Member")) {
            this._checkResourcePermissions(company.getCompanyId(), "Account Member", _accountMemberResourceActionsMap);
        }
    }

    private boolean _checkAccountRole(Company company, String roleName) throws Exception {
        Role role = this._roleLocalService.fetchRole(company.getCompanyId(), roleName);
        if (role != null) {
            if (MapUtil.isEmpty((Map)role.getDescriptionMap())) {
                role.setDescriptionMap((Map)AccountRoleConstants.roleDescriptionsMap.get(role.getName()));
                this._roleLocalService.updateRole(role);
            }
            return false;
        }
        User guestUser = company.getGuestUser();
        this._accountRoleLocalService.addAccountRole(null, guestUser.getUserId(), 0L, roleName, null, (Map)AccountRoleConstants.roleDescriptionsMap.get(roleName));
        return true;
    }

    private void _checkResourcePermissions(long companyId, String roleName, Map<String, String[]> ... resourceActionsMaps) throws Exception {
        Role role = this._roleLocalService.fetchRole(companyId, roleName);
        for (Map<String, String[]> resourceActionsMap : resourceActionsMaps) {
            for (Map.Entry<String, String[]> entry : resourceActionsMap.entrySet()) {
                for (String resourceAction : entry.getValue()) {
                    String resourceName = entry.getKey();
                    ResourcePermission resourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(companyId, resourceName, 3, "0", role.getRoleId());
                    if (resourcePermission != null && resourcePermission.hasActionId(resourceAction)) continue;
                    this._resourcePermissionLocalService.addResourcePermission(companyId, resourceName, 3, "0", role.getRoleId(), resourceAction);
                }
            }
        }
    }

    private boolean _checkRole(Company company, String roleName) throws Exception {
        Role role = this._roleLocalService.fetchRole(company.getCompanyId(), roleName);
        if (role == null) {
            User guestUser = company.getGuestUser();
            this._roleLocalService.addRole(null, guestUser.getUserId(), null, 0L, "Account Manager", null, (Map)AccountRoleConstants.roleDescriptionsMap.get("Account Manager"), 3, null, null);
            return true;
        }
        return false;
    }
}

