/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.base.AccountRoleLocalServiceBaseImpl;
import com.liferay.account.service.persistence.AccountEntryPersistence;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactory;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.util.PortalInstances;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountRole"}, service={AopService.class})
public class AccountRoleLocalServiceImpl
extends AccountRoleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountRoleLocalServiceImpl.class);
    @Reference
    private AccountEntryPersistence _accountEntryPersistence;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFactory _sortFactory;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public AccountRole addAccountRole(String externalReferenceCode, long userId, long accountEntryId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) throws PortalException {
        Role role = this._roleLocalService.addRole(externalReferenceCode, userId, AccountRole.class.getName(), 0L, name, titleMap, descriptionMap, 6, null, null);
        AccountRole accountRole = this.fetchAccountRoleByRoleId(role.getRoleId());
        if (accountRole != null) {
            accountRole.setAccountEntryId(accountEntryId);
            return this.updateAccountRole(accountRole);
        }
        accountRole = this.createAccountRole(this.counterLocalService.increment());
        accountRole.setExternalReferenceCode(role.getExternalReferenceCode());
        accountRole.setCompanyId(role.getCompanyId());
        accountRole.setAccountEntryId(accountEntryId);
        accountRole.setRoleId(role.getRoleId());
        role.setClassPK(accountRole.getAccountRoleId());
        role = this._roleLocalService.updateRole(role);
        this._resourceLocalService.addResources(role.getCompanyId(), 0L, userId, AccountRole.class.getName(), accountRole.getAccountRoleId(), false, false, false);
        return this.accountRoleLocalService.addAccountRole(accountRole);
    }

    public void associateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        this._userGroupRoleLocalService.addUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), new long[]{accountRole.getRoleId()});
    }

    public void associateUser(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        for (long accountRoleId : accountRoleIds) {
            this.associateUser(accountEntryId, accountRoleId, userId);
        }
    }

    @Override
    public AccountRole deleteAccountRole(AccountRole accountRole) throws PortalException {
        accountRole = super.deleteAccountRole(accountRole);
        this._resourceLocalService.deleteResource(accountRole.getCompanyId(), AccountRole.class.getName(), 4, accountRole.getAccountRoleId());
        Role role = this._roleLocalService.fetchRole(accountRole.getRoleId());
        if (role != null) {
            this._userGroupRoleLocalService.deleteUserGroupRolesByRoleId(accountRole.getRoleId());
            this._roleLocalService.deleteRole(accountRole.getRoleId());
        }
        return accountRole;
    }

    @Override
    public AccountRole deleteAccountRole(long accountRoleId) throws PortalException {
        return this.deleteAccountRole(this.getAccountRole(accountRoleId));
    }

    public void deleteAccountRolesByCompanyId(long companyId) throws PortalException {
        if (!PortalInstances.isCurrentCompanyInDeletionProcess()) {
            throw new UnsupportedOperationException("Deleting account roles by company must be called when deleting a company");
        }
        for (AccountRole accountRole : this.accountRolePersistence.findByCompanyId(companyId)) {
            this.accountRoleLocalService.deleteAccountRole(accountRole);
        }
    }

    public AccountRole fetchAccountRoleByRoleId(long roleId) {
        return this.accountRolePersistence.fetchByRoleId(roleId);
    }

    public AccountRole getAccountRoleByRoleId(long roleId) throws PortalException {
        return this.accountRolePersistence.findByRoleId(roleId);
    }

    public List<AccountRole> getAccountRoles(long accountEntryId, long userId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryPersistence.findByPrimaryKey(accountEntryId);
        return TransformUtil.transform((Collection)ListUtil.filter((List)this._userGroupRoleLocalService.getUserGroupRoles(userId, accountEntry.getAccountEntryGroupId()), userGroupRole -> {
            try {
                Role role = userGroupRole.getRole();
                return role.getType() == 6;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        }), userGroupRole -> this.getAccountRoleByRoleId(userGroupRole.getRoleId()));
    }

    public List<AccountRole> getAccountRolesByAccountEntryIds(long companyId, long[] accountEntryIds) {
        return this.accountRolePersistence.findByC_A(companyId, accountEntryIds);
    }

    public List<AccountRole> getAccountRolesByAccountEntryIds(long[] accountEntryIds) {
        return this.accountRolePersistence.findByAccountEntryId(accountEntryIds);
    }

    public boolean hasUserAccountRole(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        return this._userGroupRoleLocalService.hasUserGroupRole(userId, accountEntry.getAccountEntryGroupId(), accountRole.getRoleId());
    }

    public BaseModelSearchResult<AccountRole> searchAccountRoles(long companyId, long[] accountEntryIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<?> orderByComparator) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, accountEntryIds, keywords, params, start, end, orderByComparator));
        SearchHits searchHits = searchResponse.getSearchHits();
        return new BaseModelSearchResult(TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long accountRoleId = document.getLong("entryClassPK");
            AccountRole accountRole = this.fetchAccountRole(accountRoleId);
            if (accountRole == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(AccountRole.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return accountRole;
        }), searchResponse.getTotalHits());
    }

    public void setUserAccountRoles(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        ArrayList<AccountRole> removeAccountRoles = new ArrayList<AccountRole>();
        List<AccountRole> currentAccountRoles = this.getAccountRoles(accountEntryId, userId);
        for (AccountRole accountRole : currentAccountRoles) {
            if (ArrayUtil.contains((long[])accountRoleIds, (long)accountRole.getAccountRoleId())) continue;
            removeAccountRoles.add(accountRole);
        }
        this.associateUser(accountEntryId, accountRoleIds, userId);
        for (AccountRole accountRole : removeAccountRoles) {
            this.unassociateUser(accountEntryId, accountRole.getAccountRoleId(), userId);
        }
    }

    public void unassociateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        this._userGroupRoleLocalService.deleteUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), new long[]{accountRole.getRoleId()});
    }

    private SearchRequest _getSearchRequest(long companyId, long[] accountEntryIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<?> orderByComparator) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{AccountRole.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> {
            long permissionUserId;
            searchContext.setCompanyId(companyId);
            if (!Validator.isBlank((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
            searchContext.setEnd(end);
            searchContext.setStart(start);
            if (orderByComparator != null) {
                searchContext.setSorts(new Sort[]{this._sortFactory.getSort(AccountRole.class, orderByComparator.getOrderByFields()[0], orderByComparator.isAscending() ? "asc" : "desc")});
            }
            if (ArrayUtil.isNotEmpty((long[])accountEntryIds)) {
                searchContext.setAttribute("accountEntryIds", (Serializable)accountEntryIds);
            }
            if (MapUtil.isEmpty((Map)params)) {
                return;
            }
            Object[] excludedRoleNames = (String[])params.get("excludedRoleNames");
            if (ArrayUtil.isNotEmpty((Object[])excludedRoleNames)) {
                searchContext.setAttribute("excludedRoleNames", (Serializable)excludedRoleNames);
            }
            if ((permissionUserId = GetterUtil.getLong(params.get("permissionUserId"))) != 0L) {
                searchContext.setUserId(permissionUserId);
            }
        });
        return searchRequestBuilder.build();
    }
}

