/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.base.AccountEntryServiceBaseImpl;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.AddressService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountEntry"}, service={AopService.class})
public class AccountEntryServiceImpl
extends AccountEntryServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AddressService _addressService;

    public void activateAccountEntries(long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.activateAccountEntry(accountEntryId);
        }
    }

    public AccountEntry activateAccountEntry(long accountEntryId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        this._accountEntryModelResourcePermission.check(permissionChecker, accountEntryId, "UPDATE");
        return this._withServiceContext((UnsafeSupplier<AccountEntry, PortalException>)((UnsafeSupplier)() -> this.accountEntryLocalService.activateAccountEntry(accountEntryId)), permissionChecker.getUserId());
    }

    public AccountEntry addAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String email, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ACCOUNT_ENTRY");
        return this.accountEntryLocalService.addAccountEntry(externalReferenceCode, userId, parentAccountEntryId, name, description, this._getManageableDomains(0L, domains), email, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public AccountEntry addOrUpdateAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        AccountEntry accountEntry = this.accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, permissionChecker.getCompanyId());
        long accountEntryId = 0L;
        if (accountEntry == null) {
            PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"ADD_ACCOUNT_ENTRY");
        } else {
            this._accountEntryModelResourcePermission.check(permissionChecker, permissionChecker.getCompanyId(), "UPDATE");
            accountEntryId = accountEntry.getAccountEntryId();
        }
        return this.accountEntryLocalService.addOrUpdateAccountEntry(externalReferenceCode, userId, parentAccountEntryId, name, description, this._getManageableDomains(accountEntryId, domains), emailAddress, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public void deactivateAccountEntries(long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.deactivateAccountEntry(accountEntryId);
        }
    }

    public AccountEntry deactivateAccountEntry(long accountEntryId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        this._accountEntryModelResourcePermission.check(permissionChecker, accountEntryId, "DEACTIVATE");
        return this._withServiceContext((UnsafeSupplier<AccountEntry, PortalException>)((UnsafeSupplier)() -> this.accountEntryLocalService.deactivateAccountEntry(accountEntryId)), permissionChecker.getUserId());
    }

    public void deleteAccountEntries(long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.deleteAccountEntry(accountEntryId);
        }
    }

    public void deleteAccountEntry(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "DELETE");
        this.accountEntryLocalService.deleteAccountEntry(accountEntryId);
    }

    public AccountEntry fetchAccountEntry(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW");
        return this.accountEntryLocalService.fetchAccountEntry(accountEntryId);
    }

    public AccountEntry fetchAccountEntryByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, companyId);
        if (accountEntry != null) {
            this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntry.getAccountEntryId(), "VIEW");
        }
        return accountEntry;
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(null, AccountEntry.class.getName(), companyId, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), 0L, new String[]{"VIEW"});
        }
        return this.accountEntryLocalService.getAccountEntries(companyId, status, start, end, orderByComparator);
    }

    public AccountEntry getAccountEntry(long accountEntryId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntry(accountEntryId);
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW");
        return accountEntry;
    }

    public AccountEntry getAccountEntryByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntryByExternalReferenceCode(externalReferenceCode, companyId);
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntry.getAccountEntryId(), "VIEW");
        return accountEntry;
    }

    public BaseModelSearchResult<AccountEntry> searchAccountEntries(String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (params == null) {
            params = new LinkedHashMap();
        }
        params.put("permissionUserId", permissionChecker.getUserId());
        return this.accountEntryLocalService.searchAccountEntries(permissionChecker.getCompanyId(), keywords, params, cur, delta, orderByField, reverse);
    }

    public AccountEntry updateAccountEntry(AccountEntry accountEntry) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountEntry, "UPDATE");
        if (accountEntry.getDefaultBillingAddressId() > 0L) {
            this._validateAddressId(accountEntry.getDefaultBillingAddressId());
        }
        if (accountEntry.getDefaultShippingAddressId() > 0L) {
            this._validateAddressId(accountEntry.getDefaultShippingAddressId());
        }
        if (!this._accountEntryModelResourcePermission.contains(this.getPermissionChecker(), accountEntry.getAccountEntryId(), "MANAGE_DOMAINS")) {
            AccountEntry originalAccountEntry = this.accountEntryLocalService.getAccountEntry(accountEntry.getAccountEntryId());
            accountEntry.setDomains(originalAccountEntry.getDomains());
            accountEntry.setRestrictMembership(originalAccountEntry.isRestrictMembership());
        }
        return this.accountEntryLocalService.updateAccountEntry(accountEntry);
    }

    public AccountEntry updateAccountEntry(String externalReferenceCode, long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        return this.accountEntryLocalService.updateAccountEntry(externalReferenceCode, accountEntryId, parentAccountEntryId, name, description, deleteLogo, this._getManageableDomains(accountEntryId, domains), emailAddress, logoBytes, taxIdNumber, status, serviceContext);
    }

    public AccountEntry updateDefaultBillingAddressId(long accountEntryId, long addressId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        this._validateAddressId(addressId);
        return this.updateDefaultBillingAddressId(accountEntryId, addressId);
    }

    public AccountEntry updateDefaultShippingAddressId(long accountEntryId, long addressId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        this._validateAddressId(addressId);
        return this.updateDefaultShippingAddressId(accountEntryId, addressId);
    }

    public AccountEntry updateDomains(long accountEntryId, String[] domains) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_DOMAINS");
        return this.accountEntryLocalService.updateDomains(accountEntryId, domains);
    }

    public AccountEntry updateExternalReferenceCode(long accountEntryId, String externalReferenceCode) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        return this.accountEntryLocalService.updateExternalReferenceCode(accountEntryId, externalReferenceCode);
    }

    public AccountEntry updateRestrictMembership(long accountEntryId, boolean restrictMembership) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_DOMAINS");
        return this.accountEntryLocalService.updateRestrictMembership(accountEntryId, restrictMembership);
    }

    private String[] _getManageableDomains(long accountEntryId, String[] domains) throws PortalException {
        if (this._accountEntryModelResourcePermission.contains(this.getPermissionChecker(), accountEntryId, "MANAGE_DOMAINS")) {
            return domains;
        }
        return null;
    }

    private void _validateAddressId(long addressId) throws PortalException {
        if (addressId > 0L) {
            this._addressService.getAddress(addressId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccountEntry _withServiceContext(UnsafeSupplier<AccountEntry, PortalException> unsafeSupplier, long userId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            AccountEntry accountEntry = (AccountEntry)unsafeSupplier.get();
            return accountEntry;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }
}

