/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.model.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.model.impl.AccountEntryBaseImpl;
import com.liferay.account.service.AccountEntryOrganizationRelLocalServiceUtil;
import com.liferay.account.service.AccountEntryUserRelLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.AddressServiceUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ContactServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneServiceUtil;
import com.liferay.portal.kernel.service.WebsiteServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class AccountEntryImpl
extends AccountEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryImpl.class);

    public Contact fetchContact() throws PortalException {
        List contacts = ContactServiceUtil.getContacts((long)ClassNameLocalServiceUtil.getClassNameId((String)AccountEntry.class.getName()), (long)this.getAccountEntryId(), (int)0, (int)1, null);
        if (contacts.isEmpty()) {
            return null;
        }
        return (Contact)contacts.get(0);
    }

    public List<Organization> fetchOrganizations() {
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : AccountEntryOrganizationRelLocalServiceUtil.getAccountEntryOrganizationRels((long)this.getAccountEntryId())) {
            try {
                organizations.add(accountEntryOrganizationRel.getOrganization());
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return organizations;
    }

    public List<User> fetchUsers() {
        ArrayList<User> users = new ArrayList<User>();
        for (AccountEntryUserRel accountEntryUserRel : AccountEntryUserRelLocalServiceUtil.getAccountEntryUserRelsByAccountEntryId((long)this.getAccountEntryId())) {
            try {
                users.add(accountEntryUserRel.getUser());
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return users;
    }

    public Group getAccountEntryGroup() {
        return this._getAccountEntryGroup();
    }

    public long getAccountEntryGroupId() {
        Group group = this._getAccountEntryGroup();
        if (group == null) {
            return 0L;
        }
        return group.getGroupId();
    }

    public Address getDefaultBillingAddress() {
        return AddressLocalServiceUtil.fetchAddress((long)this.getDefaultBillingAddressId());
    }

    public Address getDefaultShippingAddress() {
        return AddressLocalServiceUtil.fetchAddress((long)this.getDefaultShippingAddressId());
    }

    public String[] getDomainsArray() {
        return StringUtil.split((String)this.getDomains());
    }

    public List<EmailAddress> getEmailAddresses() throws PortalException {
        return EmailAddressServiceUtil.getEmailAddresses((String)AccountEntry.class.getName(), (long)this.getAccountEntryId());
    }

    public List<Address> getListTypeAddresses(long[] listTypeIds) throws PortalException {
        return AddressServiceUtil.getListTypeAddresses((String)AccountEntry.class.getName(), (long)this.getAccountEntryId(), (long[])listTypeIds);
    }

    public List<Phone> getPhones() throws PortalException {
        return PhoneServiceUtil.getPhones((String)AccountEntry.class.getName(), (long)this.getAccountEntryId());
    }

    public List<Website> getWebsites() throws PortalException {
        return WebsiteServiceUtil.getWebsites((String)AccountEntry.class.getName(), (long)this.getAccountEntryId());
    }

    public boolean isBusinessAccount() {
        return StringUtil.equals((String)this.getType(), (String)"business");
    }

    public boolean isGuestAccount() {
        return StringUtil.equals((String)this.getType(), (String)"guest");
    }

    public boolean isPersonalAccount() {
        return StringUtil.equals((String)this.getType(), (String)"person");
    }

    private Group _getAccountEntryGroup() {
        return GroupLocalServiceUtil.fetchGroup((long)this.getCompanyId(), (long)ClassNameLocalServiceUtil.getClassNameId(AccountEntry.class), (long)this.getAccountEntryId());
    }
}

