/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.model.AccountRole;
import com.liferay.account.role.AccountRolePermissionThreadLocal;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"model.class.name=com.liferay.account.model.AccountRole"}, service={ModelResourcePermission.class})
public class AccountRoleModelResourcePermission
implements ModelResourcePermission<AccountRole> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference(target="(resource.name=com.liferay.account)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, AccountRole accountRole, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountRole, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountRole.class.getName(), accountRole.getAccountRoleId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountRoleId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountRoleId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountRole.class.getName(), accountRoleId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AccountRole accountRole, String actionId) throws PortalException {
        return this.contains(permissionChecker, accountRole.getAccountRoleId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountRoleId, String actionId) throws PortalException {
        AccountRole accountRole;
        Group group = null;
        long contextAccountEntryId = AccountRolePermissionThreadLocal.getAccountEntryId();
        if (contextAccountEntryId > 0L) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(contextAccountEntryId);
            group = accountEntry.getAccountEntryGroup();
        }
        if ((accountRole = this._accountRoleLocalService.fetchAccountRole(accountRoleId)) == null) {
            return permissionChecker.hasPermission(group, AccountRole.class.getName(), 0L, actionId);
        }
        Role role = accountRole.getRole();
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), AccountRole.class.getName(), accountRoleId, role.getUserId(), actionId)) {
            return true;
        }
        long accountRoleAccountEntryId = accountRole.getAccountEntryId();
        if (accountRoleAccountEntryId > 0L && contextAccountEntryId > 0L && !Objects.equals(accountRoleAccountEntryId, contextAccountEntryId)) {
            return false;
        }
        for (long accountEntryId : new long[]{accountRoleAccountEntryId, contextAccountEntryId}) {
            if (Objects.equals(actionId, "VIEW") && RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"VIEW")) {
                return true;
            }
            if (Objects.equals(actionId, "ASSIGN_USERS") && accountEntryId > 0L && this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntryId, "MANAGE_USERS")) {
                return true;
            }
            if (!this._checkOrganizationRolesPermission(accountEntryId, accountRoleId, actionId, permissionChecker)) continue;
            return true;
        }
        if (group == null && accountRoleAccountEntryId > 0L) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountRoleAccountEntryId);
            group = accountEntry.getAccountEntryGroup();
        }
        return permissionChecker.hasPermission(group, AccountRole.class.getName(), accountRoleId, actionId);
    }

    public String getModelName() {
        return AccountRole.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }

    private boolean _checkOrganizationRolesPermission(long accountEntryId, long accountRoleId, String actionId, PermissionChecker permissionChecker) throws PortalException {
        if (accountEntryId == 0L) {
            return false;
        }
        long[] userOrganizationIds = this._organizationLocalService.getUserOrganizationIds(permissionChecker.getUserId(), true);
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId);
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
            Organization organization;
            Organization originalOrganization = organization = this._organizationLocalService.fetchOrganization(accountEntryOrganizationRel.getOrganizationId());
            while (organization != null) {
                if (Objects.equals(organization, originalOrganization) && permissionChecker.hasPermission(organization.getGroupId(), AccountRole.class.getName(), accountRoleId, actionId)) {
                    return true;
                }
                if (!Objects.equals(organization, originalOrganization) && (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS_ACCOUNTS") || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"UPDATE_SUBORGANIZATIONS_ACCOUNTS")) && ArrayUtil.contains((long[])userOrganizationIds, (long)organization.getOrganizationId()) && permissionChecker.hasPermission(organization.getGroupId(), AccountRole.class.getName(), accountRoleId, actionId)) {
                    return true;
                }
                organization = organization.getParentOrganization();
            }
        }
        return false;
    }
}

