/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.retriever;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.retriever.AccountUserRetriever;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccountUserRetriever.class})
public class AccountUserRetrieverImpl
implements AccountUserRetriever {
    private static final Log _log = LogFactoryUtil.getLog(AccountUserRetrieverImpl.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;

    public List<User> getAccountUsers(long accountEntryId) {
        return TransformUtil.transform((Collection)this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntryId), accountEntryUserRel -> this._userLocalService.getUserById(accountEntryUserRel.getAccountUserId()));
    }

    public long getAccountUsersCount(long accountEntryId) {
        return this._accountEntryUserRelLocalService.getAccountEntryUserRelsCountByAccountEntryId(accountEntryId);
    }

    public BaseModelSearchResult<User> searchAccountRoleUsers(long accountEntryId, long accountRoleId, String keywords, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"userGroupRole", () -> {
            AccountRole accountRole = this._accountRoleLocalService.getAccountRole(accountRoleId);
            return new Long[]{accountEntry.getAccountEntryGroupId(), accountRole.getRoleId()};
        }).build();
        List users = this._userLocalService.search(accountEntry.getCompanyId(), keywords, 0, params, start, end, orderByComparator);
        int total = this._userLocalService.searchCount(accountEntry.getCompanyId(), keywords, 0, params);
        return new BaseModelSearchResult(users, total);
    }

    public BaseModelSearchResult<User> searchAccountUsers(long[] accountEntryIds, String keywords, LinkedHashMap<String, Serializable> params, int status, int cur, int delta, String sortField, boolean reverse) throws PortalException {
        if (params == null) {
            params = new LinkedHashMap();
        }
        params.put("accountEntryIds", (Serializable)accountEntryIds);
        UserSearchRequestBuilder userSearchRequestBuilder = new UserSearchRequestBuilder(params, cur, delta, keywords, reverse, status, sortField);
        SearchHits searchHits = this._searcher.search(userSearchRequestBuilder.build()).getSearchHits();
        if (searchHits == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Search hits is null");
            }
            return new BaseModelSearchResult(Collections.emptyList(), 0);
        }
        List users = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long userId = document.getLong("userId");
            User user = this._userLocalService.fetchUser(userId);
            if (user == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return user;
        });
        return new BaseModelSearchResult(users, Long.valueOf(searchHits.getTotalHits()));
    }

    private class UserSearchRequestBuilder {
        private Map<String, Serializable> _attributes = new HashMap<String, Serializable>();
        private final int _cur;
        private final int _delta;
        private final String _keywords;
        private final boolean _reverse;
        private final String _sortField;
        private final int _status;

        public UserSearchRequestBuilder(Map<String, Serializable> attributes, int cur, int delta, String keywords, boolean reverse, int status, String sortField) {
            this._attributes = attributes;
            this._cur = cur;
            this._delta = delta;
            this._keywords = keywords;
            this._reverse = reverse;
            this._status = status;
            this._sortField = sortField;
        }

        public SearchRequest build() {
            SearchRequestBuilder searchRequestBuilder = AccountUserRetrieverImpl.this._searchRequestBuilderFactory.builder();
            searchRequestBuilder.entryClassNames(new String[]{User.class.getName()}).withSearchContext(searchContext -> {
                boolean andSearch = false;
                if (Validator.isNull((String)this._keywords)) {
                    andSearch = true;
                } else {
                    searchContext.setKeywords(this._keywords);
                }
                searchContext.setAndSearch(andSearch);
                searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)this._status).put((Object)"city", (Object)this._keywords).put((Object)"country", (Object)this._keywords).put((Object)"firstName", (Object)this._keywords).put((Object)"fullName", (Object)this._keywords).put((Object)"lastName", (Object)this._keywords).put((Object)"middleName", (Object)this._keywords).put((Object)"params", new LinkedHashMap()).put((Object)"region", (Object)this._keywords).put((Object)"screenName", (Object)this._keywords).put((Object)"street", (Object)this._keywords).put((Object)"zip", (Object)this._keywords).putAll(this._attributes).build());
                searchContext.setCompanyId(CompanyThreadLocal.getCompanyId().longValue());
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                if (permissionChecker != null) {
                    searchContext.setUserId(permissionChecker.getUserId());
                }
            }).emptySearchEnabled(true).highlightEnabled(false);
            if (this._cur != -1) {
                searchRequestBuilder.from(Integer.valueOf(this._cur));
                searchRequestBuilder.size(Integer.valueOf(this._delta));
            }
            if (Validator.isNotNull((String)this._sortField)) {
                SortOrder sortOrder = SortOrder.ASC;
                if (this._reverse) {
                    sortOrder = SortOrder.DESC;
                }
                FieldSort fieldSort = AccountUserRetrieverImpl.this._sorts.field(AccountUserRetrieverImpl.this._sortFieldBuilder.getSortField(User.class, this._sortField), sortOrder);
                searchRequestBuilder.sorts(new Sort[]{fieldSort});
            }
            return searchRequestBuilder.build();
        }
    }
}

