/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.exception.DuplicateAccountGroupRelException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.model.AccountGroupRelTable;
import com.liferay.account.model.AccountGroupTable;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.base.AccountGroupRelLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountGroupRel"}, service={AopService.class})
public class AccountGroupRelLocalServiceImpl
extends AccountGroupRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountGroupRelLocalServiceImpl.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public AccountGroupRel addAccountGroupRel(long accountGroupId, String className, long classPK) throws PortalException {
        User user;
        AccountGroup accountGroup;
        AccountGroupRel accountGroupRel;
        long classNameId;
        block5: {
            classNameId = this._classNameLocalService.getClassNameId(className);
            accountGroupRel = this.accountGroupRelPersistence.fetchByA_C_C(accountGroupId, classNameId, classPK);
            if (accountGroupRel != null) {
                throw new DuplicateAccountGroupRelException();
            }
            if (Objects.equals(AccountEntry.class.getName(), className) && classPK != 0L && classPK != -1L) {
                this._accountEntryLocalService.getAccountEntry(classPK);
            }
            accountGroupRel = this.createAccountGroupRel(this.counterLocalService.increment());
            accountGroup = this._accountGroupLocalService.getAccountGroup(accountGroupId);
            user = null;
            try {
                user = GuestOrUserUtil.getGuestOrUser((long)accountGroup.getCompanyId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Throwable)portalException);
            }
        }
        if (user == null) {
            user = this._userLocalService.getGuestUser(accountGroup.getCompanyId());
        }
        accountGroupRel.setCompanyId(user.getCompanyId());
        accountGroupRel.setUserId(user.getUserId());
        accountGroupRel.setUserName(user.getFullName());
        accountGroupRel.setCreateDate(new Date());
        accountGroupRel.setModifiedDate(new Date());
        accountGroupRel.setAccountGroupId(accountGroupId);
        accountGroupRel.setClassNameId(classNameId);
        accountGroupRel.setClassPK(classPK);
        return this.addAccountGroupRel(accountGroupRel);
    }

    public void addAccountGroupRels(long accountGroupId, String className, long[] classPKs) throws PortalException {
        for (long classPK : classPKs) {
            this.addAccountGroupRel(accountGroupId, className, classPK);
        }
    }

    public void deleteAccountGroupRels(long accountGroupId, String className, long[] classPKs) throws PortalException {
        for (long classPK : classPKs) {
            this.accountGroupRelPersistence.removeByA_C_C(accountGroupId, this._classNameLocalService.getClassNameId(className), classPK);
        }
    }

    public void deleteAccountGroupRels(String className, long[] classPKs) {
        for (long classPK : classPKs) {
            this.accountGroupRelPersistence.removeByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        }
    }

    public void deleteAccountGroupRelsByAccountGroupId(long accountGroupId) {
        this.accountGroupRelPersistence.removeByAccountGroupId(accountGroupId);
    }

    public AccountGroupRel fetchAccountGroupRel(long accountGroupId, String className, long classPK) {
        return this.accountGroupRelPersistence.fetchByA_C_C(accountGroupId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<AccountGroupRel> getAccountGroupRels(long accountGroupId, String className) {
        return this.accountGroupRelPersistence.findByA_C(accountGroupId, this._classNameLocalService.getClassNameId(className));
    }

    public List<AccountGroupRel> getAccountGroupRels(long[] accountGroupIds, String className, long classPK, String keywords, int start, int end) {
        return (List)this.dslQuery(DSLQueryFactoryUtil.select((Table)AccountGroupRelTable.INSTANCE).from((Table)AccountGroupRelTable.INSTANCE).innerJoinON((Table)AccountGroupTable.INSTANCE, AccountGroupTable.INSTANCE.accountGroupId.eq((Expression)AccountGroupRelTable.INSTANCE.accountGroupId)).where(this._getPredicate(accountGroupIds, className, classPK, keywords)).limit(start, end));
    }

    public List<AccountGroupRel> getAccountGroupRels(String className, long classPK) {
        return this.accountGroupRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<AccountGroupRel> getAccountGroupRels(String className, long classPK, int start, int end, OrderByComparator<AccountGroupRel> orderByComparator) {
        return this.accountGroupRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<AccountGroupRel> getAccountGroupRelsByAccountGroupId(long accountGroupId) {
        return this.accountGroupRelPersistence.findByAccountGroupId(accountGroupId);
    }

    public List<AccountGroupRel> getAccountGroupRelsByAccountGroupId(long accountGroupId, int start, int end, OrderByComparator<AccountGroupRel> orderByComparator) {
        return this.accountGroupRelPersistence.findByAccountGroupId(accountGroupId, start, end, orderByComparator);
    }

    public int getAccountGroupRelsCount(long[] accountGroupIds, String className, long classPK, String keywords) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)AccountGroupRelTable.INSTANCE).innerJoinON((Table)AccountGroupTable.INSTANCE, AccountGroupTable.INSTANCE.accountGroupId.eq((Expression)AccountGroupRelTable.INSTANCE.accountGroupId)).where(this._getPredicate(accountGroupIds, className, classPK, keywords)));
    }

    public int getAccountGroupRelsCount(String className, long classPK) {
        return this.accountGroupRelPersistence.countByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public long getAccountGroupRelsCountByAccountGroupId(long accountGroupId) {
        return this.accountGroupRelPersistence.countByAccountGroupId(accountGroupId);
    }

    private Predicate _getPredicate(long[] accountGroupIds, String className, long classPK, String keywords) {
        Predicate predicate = AccountGroupRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className)).and((Expression)AccountGroupRelTable.INSTANCE.classPK.eq((Object)classPK)).and(() -> {
            if (ArrayUtil.isEmpty((long[])accountGroupIds)) {
                return null;
            }
            return AccountGroupRelTable.INSTANCE.accountGroupId.in((Object[])ArrayUtil.toArray((long[])accountGroupIds));
        });
        if (Validator.isNotNull((String)keywords)) {
            return Predicate.withParentheses((Predicate)predicate.and((Expression)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)AccountGroupTable.INSTANCE.name), this._customSQL.keywords(keywords, true))));
        }
        return predicate;
    }
}

