/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.configuration.AccountEntryEmailConfiguration;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.exception.AccountEntryUserRelEmailAddressException;
import com.liferay.account.exception.DuplicateAccountEntryIdException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.model.AccountEntryUserRelModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.account.service.base.AccountEntryUserRelLocalServiceBaseImpl;
import com.liferay.account.validator.AccountEntryEmailAddressValidator;
import com.liferay.account.validator.AccountEntryEmailAddressValidatorFactory;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.kernel.template.MailTemplateFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.EscapableObject;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntryUserRel"}, service={AopService.class})
public class AccountEntryUserRelLocalServiceImpl
extends AccountEntryUserRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryUserRelLocalServiceImpl.class);
    @Reference
    private AccountEntryEmailAddressValidatorFactory _accountEntryEmailAddressValidatorFactory;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private MailService _mailService;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, accountUserId);
        if (accountEntryUserRel != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Account entry user relationship already exists for ", "account entry ", accountEntryId, " and user ", accountUserId}));
            }
            return accountEntryUserRel;
        }
        if (accountEntryId != 0L) {
            this._accountEntryLocalService.getAccountEntry(accountEntryId);
        }
        User accountUser = this._userLocalService.getUser(accountUserId);
        this._validateEmailAddress(this._accountEntryEmailAddressValidatorFactory.create(accountUser.getCompanyId(), this._getAccountDomains(accountEntryId)), accountUser.getEmailAddress());
        accountEntryUserRel = this.createAccountEntryUserRel(this.counterLocalService.increment());
        accountEntryUserRel.setAccountEntryId(accountEntryId);
        accountEntryUserRel.setAccountUserId(accountUserId);
        return this.addAccountEntryUserRel(accountEntryUserRel);
    }

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixListTypeId, long suffixListTypeId, String jobTitle, ServiceContext serviceContext) throws PortalException {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (accountEntryId != 0L) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            companyId = accountEntry.getCompanyId();
        }
        this._validateEmailAddress(this._accountEntryEmailAddressValidatorFactory.create(companyId, this._getAccountDomains(accountEntryId)), emailAddress);
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        boolean male = true;
        int birthdayMonth = Month.JANUARY.getValue();
        int birthdayDay = 1;
        int birthdayYear = 1970;
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        User user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, 1, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        return this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, user.getUserId());
    }

    public AccountEntryUserRel addAccountEntryUserRelByEmailAddress(long accountEntryId, String emailAddress, long[] accountRoleIds, String userExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        User user = null;
        if (Validator.isNotNull((String)userExternalReferenceCode)) {
            user = this._userLocalService.fetchUserByExternalReferenceCode(userExternalReferenceCode, serviceContext.getCompanyId());
        }
        if (user == null) {
            if (Validator.isNull((String)emailAddress)) {
                throw new AccountEntryUserRelEmailAddressException();
            }
            user = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), emailAddress);
        }
        if (user == null) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            Group group = accountEntry.getAccountEntryGroup();
            long[] groupIds = new long[]{group.getGroupId()};
            if (serviceContext.getScopeGroupId() > 0L) {
                groupIds = ArrayUtil.append((long[])groupIds, (long)serviceContext.getScopeGroupId());
            }
            user = this._userLocalService.addUserWithWorkflow(serviceContext.getUserId(), serviceContext.getCompanyId(), true, "", "", true, "", emailAddress, serviceContext.getLocale(), emailAddress, "", emailAddress, 0L, 0L, true, 1, 1, 1970, "", 1, groupIds, null, null, null, true, serviceContext);
            user.setExternalReferenceCode(userExternalReferenceCode);
            user = this._userLocalService.updateUser(user);
        }
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, user.getUserId());
        this._updateRoles(accountEntryId, user.getUserId(), accountRoleIds);
        return accountEntryUserRel;
    }

    public void addAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        for (long accountUserId : accountUserIds) {
            this.addAccountEntryUserRel(accountEntryId, accountUserId);
        }
    }

    public AccountEntryUserRel addPersonTypeAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixListTypeId, long suffixListTypeId, String jobTitle, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        if (!Objects.equals("person", accountEntry.getType())) {
            throw new AccountEntryTypeException();
        }
        this.deleteAccountEntryUserRelsByAccountEntryId(accountEntryId);
        return this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, creatorUserId, screenName, emailAddress, locale, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, jobTitle, serviceContext);
    }

    public void deleteAccountEntryUserRelByEmailAddress(long accountEntryId, String emailAddress) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        User user = this._userLocalService.getUserByEmailAddress(accountEntry.getCompanyId(), emailAddress);
        this.accountEntryUserRelPersistence.removeByAEI_AUI(accountEntry.getAccountEntryId(), user.getUserId());
    }

    public void deleteAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        for (long accountUserId : accountUserIds) {
            this.accountEntryUserRelPersistence.removeByAEI_AUI(accountEntryId, accountUserId);
        }
    }

    public void deleteAccountEntryUserRelsByAccountEntryId(long accountEntryId) {
        for (AccountEntryUserRel accountEntryUserRel : this.getAccountEntryUserRelsByAccountEntryId(accountEntryId)) {
            this.deleteAccountEntryUserRel(accountEntryUserRel);
        }
    }

    public void deleteAccountEntryUserRelsByAccountUserId(long accountUserId) {
        for (AccountEntryUserRel accountEntryUserRel : this.getAccountEntryUserRelsByAccountUserId(accountUserId)) {
            this.deleteAccountEntryUserRel(accountEntryUserRel);
        }
    }

    public AccountEntryUserRel fetchAccountEntryUserRel(long accountEntryId, long accountUserId) {
        return this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, accountUserId);
    }

    public AccountEntryUserRel getAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        return this.accountEntryUserRelPersistence.findByAEI_AUI(accountEntryId, accountUserId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId) {
        return this.accountEntryUserRelPersistence.findByAccountEntryId(accountEntryId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId, int start, int end) {
        return this.accountEntryUserRelPersistence.findByAccountEntryId(accountEntryId, start, end);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountUserId(long accountUserId) {
        return this.accountEntryUserRelPersistence.findByAccountUserId(accountUserId);
    }

    public long getAccountEntryUserRelsCountByAccountEntryId(long accountEntryId) {
        return this.accountEntryUserRelPersistence.countByAccountEntryId(accountEntryId);
    }

    public boolean hasAccountEntryUserRel(long accountEntryId, long userId) {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, userId);
        return accountEntryUserRel != null;
    }

    public void inviteUser(long accountEntryId, long[] accountRoleIds, String emailAddress, User inviter, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.fetchUserByEmailAddress(inviter.getCompanyId(), emailAddress);
        if (user != null) {
            this.addAccountEntryUserRel(accountEntryId, user.getUserId());
            this._updateRoles(accountEntryId, user.getUserId(), accountRoleIds);
        } else {
            this._sendEmail(accountEntryId, accountRoleIds, emailAddress, inviter, serviceContext);
        }
    }

    public boolean isAccountEntryUser(long userId) {
        return this.accountEntryUserRelPersistence.countByAccountUserId(userId) > 0;
    }

    public void setAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        if (accountUserIds == null) {
            return;
        }
        Set newAccountUserIds = SetUtil.fromArray((long[])accountUserIds);
        Set oldAccountUserIds = SetUtil.fromCollection((Collection)ListUtil.toList(this.getAccountEntryUserRelsByAccountEntryId(accountEntryId), AccountEntryUserRelModel::getAccountUserId));
        HashSet removeAccountUserIds = new HashSet(oldAccountUserIds);
        removeAccountUserIds.removeAll(newAccountUserIds);
        this.deleteAccountEntryUserRels(accountEntryId, ArrayUtil.toLongArray(removeAccountUserIds));
        newAccountUserIds.removeAll(oldAccountUserIds);
        this.addAccountEntryUserRels(accountEntryId, ArrayUtil.toLongArray((Collection)newAccountUserIds));
    }

    public void setPersonTypeAccountEntryUser(long accountEntryId, long userId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        if (!Objects.equals("person", accountEntry.getType())) {
            throw new AccountEntryTypeException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating user for person account entry: " + accountEntryId));
        }
        ArrayList<AccountEntryUserRel> removeAccountEntryUserRels = new ArrayList<AccountEntryUserRel>(this.getAccountEntryUserRelsByAccountEntryId(accountEntryId));
        boolean currentAccountUser = removeAccountEntryUserRels.removeIf(accountEntryUserRel -> accountEntryUserRel.getAccountUserId() == userId);
        removeAccountEntryUserRels.forEach(accountEntryUserRel -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing user: " + accountEntryUserRel.getAccountUserId()));
            }
            this.deleteAccountEntryUserRel((AccountEntryUserRel)accountEntryUserRel);
        });
        if (userId > 0L && !currentAccountUser) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding user: " + userId));
            }
            this.addAccountEntryUserRel(accountEntryId, userId);
        }
    }

    public void updateAccountEntryUserRels(long[] addAccountEntryIds, long[] deleteAccountEntryIds, long accountUserId) throws PortalException {
        Set set = SetUtil.intersect((long[])addAccountEntryIds, (long[])deleteAccountEntryIds);
        if (SetUtil.isNotEmpty((Set)set)) {
            throw new DuplicateAccountEntryIdException();
        }
        for (long addAccountEntryId : addAccountEntryIds) {
            if (this.hasAccountEntryUserRel(addAccountEntryId, accountUserId)) continue;
            this.addAccountEntryUserRel(addAccountEntryId, accountUserId);
        }
        for (long deleteAccountEntryId : deleteAccountEntryIds) {
            if (!this.hasAccountEntryUserRel(deleteAccountEntryId, accountUserId)) continue;
            this.accountEntryUserRelPersistence.removeByAEI_AUI(deleteAccountEntryId, accountUserId);
        }
    }

    private String[] _getAccountDomains(long accountEntryId) {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(accountEntryId);
        if (accountEntry == null || !accountEntry.isRestrictMembership()) {
            return new String[0];
        }
        return accountEntry.getDomainsArray();
    }

    private void _sendEmail(long accountEntryId, long[] accountRoleIds, String emailAddress, User inviter, ServiceContext serviceContext) throws PortalException {
        this._validateEmailAddress(this._accountEntryEmailAddressValidatorFactory.create(inviter.getCompanyId(), this._getAccountDomains(accountEntryId)), emailAddress);
        try {
            AccountEntryEmailConfiguration accountEntryEmailConfiguration = (AccountEntryEmailConfiguration)this._configurationProvider.getCompanyConfiguration(AccountEntryEmailConfiguration.class, inviter.getCompanyId());
            int invitationTokenExpirationTime = accountEntryEmailConfiguration.invitationTokenExpirationTime();
            Ticket ticket = this._ticketLocalService.addTicket(inviter.getCompanyId(), AccountEntry.class.getName(), accountEntryId, 5, JSONUtil.put((String)"accountRoleIds", (Object)accountRoleIds).put("emailAddress", emailAddress).toString(), new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(invitationTokenExpirationTime)), serviceContext);
            Group guestGroup = this._groupLocalService.getGroup(inviter.getCompanyId(), "Guest");
            String url = PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)serviceContext.getRequest(), (String)"com_liferay_account_admin_web_internal_portlet_AccountUsersRegistrationPortlet", (Layout)this._layoutLocalService.fetchDefaultLayout(guestGroup.getGroupId(), false), (String)"RENDER_PHASE")).setMVCRenderCommandName("/account_admin/create_account_user").setParameter("ticketKey", ticket.getKey()).setPortletMode(PortletMode.VIEW).setWindowState(WindowState.MAXIMIZED).buildString();
            MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            mailTemplateContextBuilder.put("[$ACCOUNT_NAME$]", new EscapableObject((Object)accountEntry.getName()));
            mailTemplateContextBuilder.put("[$CREATE_ACCOUNT_URL$]", url);
            String invitationEmailSenderName = accountEntryEmailConfiguration.invitationEmailSenderName();
            if (Validator.isNull((String)invitationEmailSenderName)) {
                invitationEmailSenderName = inviter.getFullName();
            }
            mailTemplateContextBuilder.put("[$INVITE_SENDER_NAME$]", new EscapableObject((Object)invitationEmailSenderName));
            MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
            LocalizedValuesMap subjectLocalizedValuesMap = accountEntryEmailConfiguration.invitationEmailSubject();
            MailTemplate subjectMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)subjectLocalizedValuesMap.get(inviter.getLocale()), (boolean)false);
            LocalizedValuesMap bodyLocalizedValuesMap = accountEntryEmailConfiguration.invitationEmailBody();
            MailTemplate bodyMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)bodyLocalizedValuesMap.get(inviter.getLocale()), (boolean)true);
            String invitationEmailSenderEmailAddress = accountEntryEmailConfiguration.invitationEmailSenderEmailAddress();
            if (Validator.isNull((String)invitationEmailSenderEmailAddress)) {
                invitationEmailSenderEmailAddress = inviter.getEmailAddress();
            }
            MailMessage mailMessage = new MailMessage(new InternetAddress(invitationEmailSenderEmailAddress, invitationEmailSenderName), new InternetAddress(emailAddress), subjectMailTemplate.renderAsString(inviter.getLocale(), mailTemplateContext), bodyMailTemplate.renderAsString(inviter.getLocale(), mailTemplateContext), true);
            this._mailService.sendEmail(mailMessage);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _updateRoles(long accountEntryId, long userId, long[] accountRoleIds) throws PortalException {
        if (accountRoleIds == null) {
            return;
        }
        this._accountRoleLocalService.associateUser(accountEntryId, accountRoleIds, userId);
    }

    private void _validateEmailAddress(AccountEntryEmailAddressValidator accountEntryEmailAddressValidator, String emailAddress) throws PortalException {
        if (accountEntryEmailAddressValidator.isBlockedDomain(emailAddress)) {
            throw new UserEmailAddressException.MustNotUseBlockedDomain(emailAddress, StringUtil.merge((Object[])accountEntryEmailAddressValidator.getBlockedDomains(), (String)", "));
        }
        if (!accountEntryEmailAddressValidator.isValidDomain(emailAddress)) {
            throw new UserEmailAddressException.MustHaveValidDomain(emailAddress, StringUtil.merge((Object[])accountEntryEmailAddressValidator.getValidDomains()));
        }
    }
}

