/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntry"}, service={ModelResourcePermission.class})
public class AccountEntryModelResourcePermission
implements ModelResourcePermission<AccountEntry> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference(target="(resource.name=com.liferay.account)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, AccountEntry accountEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntry.getAccountEntryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AccountEntry accountEntry, String actionId) throws PortalException {
        return this.contains(permissionChecker, accountEntry.getAccountEntryId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountEntryId, String actionId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(accountEntryId);
        if (accountEntry != null && permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), AccountEntry.class.getName(), accountEntryId, accountEntry.getUserId(), actionId)) {
            return true;
        }
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId);
        long[] userOrganizationIds = this._organizationLocalService.getUserOrganizationIds(permissionChecker.getUserId(), true);
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
            Organization organization;
            Organization originalOrganization = organization = this._organizationLocalService.fetchOrganization(accountEntryOrganizationRel.getOrganizationId());
            while (organization != null) {
                if (Objects.equals(actionId, "UPDATE_ORGANIZATIONS") && permissionChecker.hasPermission(organization.getGroupId(), AccountEntry.class.getName(), accountEntryId, "MANAGE_ORGANIZATIONS")) {
                    return true;
                }
                boolean organizationMember = ArrayUtil.contains((long[])userOrganizationIds, (long)organization.getOrganizationId());
                if (!Objects.equals(actionId, "MANAGE_ORGANIZATIONS") && !Objects.equals(actionId, "UPDATE_ORGANIZATIONS") && organizationMember && OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organization.getOrganizationId(), (String)"MANAGE_AVAILABLE_ACCOUNTS")) {
                    return true;
                }
                if (Objects.equals(organization, originalOrganization) && permissionChecker.hasPermission(organization.getGroupId(), AccountEntry.class.getName(), accountEntryId, actionId)) {
                    return true;
                }
                if (!Objects.equals(organization, originalOrganization) && (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS_ACCOUNTS") || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"UPDATE_SUBORGANIZATIONS_ACCOUNTS")) && (organizationMember && Objects.equals(actionId, "VIEW") || permissionChecker.hasPermission(organization.getGroupId(), AccountEntry.class.getName(), accountEntryId, actionId))) {
                    return true;
                }
                organization = organization.getParentOrganization();
            }
        }
        long accountEntryGroupId = 0L;
        if (accountEntry != null) {
            accountEntryGroupId = accountEntry.getAccountEntryGroupId();
        }
        if (Objects.equals(actionId, "UPDATE_ORGANIZATIONS") && permissionChecker.hasPermission(accountEntryGroupId, AccountEntry.class.getName(), accountEntryId, "MANAGE_ORGANIZATIONS")) {
            return true;
        }
        return permissionChecker.hasPermission(accountEntryGroupId, AccountEntry.class.getName(), accountEntryId, actionId);
    }

    public String getModelName() {
        return AccountEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

