/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelDocumentContributor.class})
public class UserModelDocumentContributor
implements ModelDocumentContributor<User> {
    @Reference
    protected AccountEntryUserRelLocalService accountEntryUserRelLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserModelDocumentContributor.class);

    public void contribute(Document document, User user) {
        block3: {
            try {
                long[] accountEntryIds = this.getAccountEntryIds(user);
                if (ArrayUtil.isNotEmpty((long[])accountEntryIds)) {
                    document.addKeyword("accountEntryIds", accountEntryIds);
                    document.addKeyword("emailAddressDomain", this._getEmailAddressDomain(user));
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)exception);
            }
        }
    }

    protected long[] getAccountEntryIds(User user) throws Exception {
        HashSet<Long> accountEntryIds = new HashSet<Long>();
        for (AccountEntryUserRel accountEntryUserRel : this.accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(user.getUserId())) {
            accountEntryIds.add(accountEntryUserRel.getAccountEntryId());
        }
        return ArrayUtil.toLongArray(accountEntryIds);
    }

    private String _getEmailAddressDomain(User user) {
        String emailAddress = user.getEmailAddress();
        return emailAddress.substring(emailAddress.indexOf("@") + 1);
    }
}

