/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.Role", "service.ranking:Integer=100"}, service={ModelDocumentContributor.class})
public class RoleModelDocumentContributor
implements ModelDocumentContributor<Role> {
    private static final Log _log = LogFactoryUtil.getLog(RoleModelDocumentContributor.class);
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;

    public void contribute(Document document, Role role) {
        block4: {
            try {
                if (!Objects.equals(role.getClassName(), AccountRole.class.getName())) {
                    return;
                }
                AccountRole accountRole = this._accountRoleLocalService.fetchAccountRole(role.getClassPK());
                if (accountRole == null) {
                    return;
                }
                document.addKeyword("accountEntryId", accountRole.getAccountEntryId());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to index role " + role.getRoleId()), (Throwable)exception);
            }
        }
    }
}

