/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.model.AccountGroupRelModel;
import com.liferay.account.retriever.AccountUserRetriever;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountGroupRelLocalService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.account.model.AccountEntry"}, service={ModelDocumentContributor.class})
public class AccountEntryModelDocumentContributor
implements ModelDocumentContributor<AccountEntry> {
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountGroupRelLocalService _accountGroupRelLocalService;
    @Reference
    private AccountUserRetriever _accountUserRetriever;

    public void contribute(Document document, AccountEntry accountEntry) {
        document.addText("description", accountEntry.getDescription());
        document.addText("name", accountEntry.getName());
        document.addKeyword("status", accountEntry.getStatus());
        String type = accountEntry.getType();
        document.addKeyword("type", type);
        document.addKeyword("accountEntryId", accountEntry.getAccountEntryId());
        document.addKeyword("accountGroupIds", this._getAccountGroupIds(accountEntry));
        long[] accountUserIds = this._getAccountUserIds(accountEntry);
        document.addKeyword("accountUserIds", accountUserIds);
        document.addKeyword("allowNewUserMembership", this._isAllowNewUserMembership(accountUserIds, type));
        document.addKeyword("domains", this._getDomains(accountEntry));
        document.addKeyword("externalReferenceCode", accountEntry.getExternalReferenceCode());
        document.addKeyword("organizationIds", this._getOrganizationIds(accountEntry));
        document.addKeyword("parentAccountEntryId", accountEntry.getParentAccountEntryId());
        document.addText("taxIdNumber", accountEntry.getTaxIdNumber());
        document.remove("userName");
    }

    private long[] _getAccountGroupIds(AccountEntry accountEntry) {
        return ListUtil.toLongArray((List)this._accountGroupRelLocalService.getAccountGroupRels(AccountEntry.class.getName(), accountEntry.getAccountEntryId()), AccountGroupRelModel::getAccountGroupId);
    }

    private long[] _getAccountUserIds(AccountEntry accountEntry) {
        return ListUtil.toLongArray((List)this._accountUserRetriever.getAccountUsers(accountEntry.getAccountEntryId()), (Accessor)User.USER_ID_ACCESSOR);
    }

    private String[] _getDomains(AccountEntry accountEntry) {
        return ArrayUtil.toStringArray((Collection)StringUtil.split((String)accountEntry.getDomains(), (char)','));
    }

    private long[] _getOrganizationIds(AccountEntry accountEntry) {
        return ListUtil.toLongArray((List)this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId()), AccountEntryOrganizationRelModel::getOrganizationId);
    }

    private boolean _isAllowNewUserMembership(long[] accountUserIds, String type) {
        return !Objects.equals(type, "person") || !ArrayUtil.isNotEmpty((long[])accountUserIds);
    }
}

