/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.account.model.impl;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountGroupLocalServiceUtil;

/**
 * The extended model base implementation for the AccountGroup service. Represents a row in the &quot;AccountGroup&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AccountGroupImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountGroupImpl
 * @see AccountGroup
 * @generated
 */
public abstract class AccountGroupBaseImpl
	extends AccountGroupModelImpl implements AccountGroup {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a account group model instance should use the <code>AccountGroup</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AccountGroupLocalServiceUtil.addAccountGroup(this);
		}
		else {
			AccountGroupLocalServiceUtil.updateAccountGroup(this);
		}
	}

}