/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.base.AccountRoleLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.account.model.AccountRole"}, service={AopService.class})
public class AccountRoleLocalServiceImpl
extends AccountRoleLocalServiceBaseImpl {
    public AccountRole addAccountRole(long userId, long accountEntryId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) throws PortalException {
        AccountRole accountRole = this.createAccountRole(this.counterLocalService.increment());
        accountRole.setAccountEntryId(accountEntryId);
        User user = this.userLocalService.getUser(userId);
        accountRole.setCompanyId(user.getCompanyId());
        Role role = this.roleLocalService.addRole(userId, AccountRole.class.getName(), accountRole.getAccountRoleId(), name, titleMap, descriptionMap, 4, null, null);
        accountRole.setRoleId(role.getRoleId());
        return this.addAccountRole(accountRole);
    }

    public void associateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        this.userGroupRoleLocalService.addUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), new long[]{accountRole.getRoleId()});
    }

    @Override
    public AccountRole deleteAccountRole(AccountRole accountRole) throws PortalException {
        Role role = this.roleLocalService.fetchRole((accountRole = super.deleteAccountRole(accountRole)).getRoleId());
        if (role != null) {
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(accountRole.getRoleId());
            this.roleLocalService.deleteRole(accountRole.getRoleId());
        }
        return accountRole;
    }

    @Override
    public AccountRole deleteAccountRole(long accountRoleId) throws PortalException {
        return this.deleteAccountRole(this.getAccountRole(accountRoleId));
    }

    public void deleteAccountRolesByCompanyId(long companyId) {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            throw new UnsupportedOperationException("Deleting account roles by company must be called when deleting a company");
        }
        for (AccountRole accountRole : this.accountRolePersistence.findByCompanyId(companyId)) {
            this.accountRolePersistence.remove((BaseModel)accountRole);
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(accountRole.getRoleId());
        }
    }

    public AccountRole fetchAccountRoleByRoleId(long roleId) {
        return this.accountRolePersistence.fetchByRoleId(roleId);
    }

    public AccountRole getAccountRoleByRoleId(long roleId) throws PortalException {
        return this.accountRolePersistence.findByRoleId(roleId);
    }

    public List<AccountRole> getAccountRoles(long accountEntryId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        return TransformUtil.transform((Collection)this.userGroupRoleLocalService.getUserGroupRoles(userId, accountEntry.getAccountEntryGroupId()), userGroupRole -> this.getAccountRoleByRoleId(userGroupRole.getRoleId()));
    }

    public List<AccountRole> getAccountRolesByAccountEntryIds(long[] accountEntryIds) {
        return this.accountRolePersistence.findByAccountEntryId(accountEntryIds);
    }

    public BaseModelSearchResult<AccountRole> searchAccountRoles(long accountEntryId, String keywords, int start, int end, OrderByComparator<?> orderByComparator) {
        return this.searchAccountRoles(new long[]{accountEntryId}, keywords, start, end, orderByComparator);
    }

    public BaseModelSearchResult<AccountRole> searchAccountRoles(long[] accountEntryIds, String keywords, int start, int end, OrderByComparator<?> orderByComparator) {
        DynamicQuery roleDynamicQuery = this._getRoleDynamicQuery(accountEntryIds, keywords, orderByComparator);
        if (roleDynamicQuery == null) {
            return new BaseModelSearchResult(Collections.emptyList(), 0);
        }
        List accountRoles = TransformUtil.transform((Collection)this.roleLocalService.dynamicQuery(roleDynamicQuery, start, end), userGroupRole -> this.getAccountRoleByRoleId(userGroupRole.getRoleId()));
        return new BaseModelSearchResult(accountRoles, (int)this.roleLocalService.dynamicQueryCount(this._getRoleDynamicQuery(accountEntryIds, keywords, null)));
    }

    public void unassociateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), new long[]{accountRole.getRoleId()});
    }

    private DynamicQuery _getRoleDynamicQuery(long[] accountEntryIds, String keywords, OrderByComparator<?> orderByComparator) {
        DynamicQuery accountRoleDynamicQuery = this.accountRoleLocalService.dynamicQuery();
        accountRoleDynamicQuery.add(RestrictionsFactoryUtil.in((String)"accountEntryId", (Collection)ListUtil.fromArray((long[])accountEntryIds)));
        accountRoleDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"roleId"));
        List roleIds = this.accountRoleLocalService.dynamicQuery(accountRoleDynamicQuery);
        if (roleIds.isEmpty()) {
            return null;
        }
        DynamicQuery roleDynamicQuery = this.roleLocalService.dynamicQuery();
        roleDynamicQuery.add(RestrictionsFactoryUtil.in((String)"roleId", (Collection)roleIds));
        if (Validator.isNotNull((String)keywords)) {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)StringUtil.quote((String)keywords, (String)"%")));
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"description", (Object)StringUtil.quote((String)keywords, (String)"%")));
            roleDynamicQuery.add((Criterion)disjunction);
        }
        OrderFactoryUtil.addOrderByComparator((DynamicQuery)roleDynamicQuery, orderByComparator);
        return roleDynamicQuery;
    }
}

