/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupAccountEntryRel;
import com.liferay.account.service.base.AccountGroupLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.account.model.AccountGroup"}, service={AopService.class})
public class AccountGroupLocalServiceImpl
extends AccountGroupLocalServiceBaseImpl {
    public AccountGroup addAccountGroup(long userId, String name, String description) throws PortalException {
        long accountGroupId = this.counterLocalService.increment();
        AccountGroup accountGroup = this.accountGroupPersistence.create(accountGroupId);
        User user = this.userLocalService.getUser(userId);
        accountGroup.setCompanyId(user.getCompanyId());
        accountGroup.setUserId(user.getUserId());
        accountGroup.setUserName(user.getFullName());
        accountGroup.setName(name);
        accountGroup.setDescription(description);
        return (AccountGroup)this.accountGroupPersistence.update((BaseModel)accountGroup);
    }

    @Override
    public AccountGroup deleteAccountGroup(AccountGroup accountGroup) {
        this.accountGroupPersistence.remove((BaseModel)accountGroup);
        List accountGroupAccountEntryRels = this.accountGroupAccountEntryRelPersistence.findByAccountGroupId(accountGroup.getAccountGroupId());
        for (AccountGroupAccountEntryRel accountGroupAccountEntryRel : accountGroupAccountEntryRels) {
            this.accountGroupAccountEntryRelPersistence.remove((BaseModel)accountGroupAccountEntryRel);
        }
        return accountGroup;
    }

    @Override
    public AccountGroup deleteAccountGroup(long accountGroupId) throws PortalException {
        return this.deleteAccountGroup(this.accountGroupLocalService.getAccountGroup(accountGroupId));
    }

    public List<AccountGroup> getAccountGroups(long companyId, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.accountGroupPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public BaseModelSearchResult<AccountGroup> searchAccountGroups(long companyId, String keywords, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return new BaseModelSearchResult(this.accountGroupLocalService.dynamicQuery(this._getDynamicQuery(companyId, keywords, orderByComparator), start, end, orderByComparator), (int)this.accountGroupLocalService.dynamicQueryCount(this._getDynamicQuery(companyId, keywords, null)));
    }

    public AccountGroup updateAccountGroup(long accountGroupId, String name, String description) throws PortalException {
        AccountGroup accountGroup = this.accountGroupPersistence.fetchByPrimaryKey(accountGroupId);
        accountGroup.setName(name);
        accountGroup.setDescription(description);
        return (AccountGroup)this.accountGroupPersistence.update((BaseModel)accountGroup);
    }

    private DynamicQuery _getDynamicQuery(long companyId, String keywords, OrderByComparator<AccountGroup> orderByComparator) {
        DynamicQuery dynamicQuery = this.accountGroupLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId));
        if (Validator.isNotNull((String)keywords)) {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)StringUtil.quote((String)keywords, (String)"%")));
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"description", (Object)StringUtil.quote((String)keywords, (String)"%")));
            dynamicQuery.add((Criterion)disjunction);
        }
        OrderFactoryUtil.addOrderByComparator((DynamicQuery)dynamicQuery, orderByComparator);
        return dynamicQuery;
    }
}

