/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.exception.DuplicateAccountGroupAccountEntryRelException;
import com.liferay.account.model.AccountGroupAccountEntryRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.base.AccountGroupAccountEntryRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountGroupAccountEntryRel"}, service={AopService.class})
public class AccountGroupAccountEntryRelLocalServiceImpl
extends AccountGroupAccountEntryRelLocalServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;

    public AccountGroupAccountEntryRel addAccountGroupAccountEntryRel(long accountGroupId, long accountEntryId) throws PortalException {
        AccountGroupAccountEntryRel accountGroupAccountEntryRel = this.accountGroupAccountEntryRelPersistence.fetchByAGI_AEI(accountGroupId, accountEntryId);
        if (accountGroupAccountEntryRel != null) {
            throw new DuplicateAccountGroupAccountEntryRelException();
        }
        this._accountGroupLocalService.getAccountGroup(accountGroupId);
        if (accountEntryId != 0L) {
            this._accountEntryLocalService.getAccountEntry(accountEntryId);
        }
        accountGroupAccountEntryRel = this.createAccountGroupAccountEntryRel(this.counterLocalService.increment());
        accountGroupAccountEntryRel.setAccountGroupId(accountGroupId);
        accountGroupAccountEntryRel.setAccountEntryId(accountEntryId);
        return this.addAccountGroupAccountEntryRel(accountGroupAccountEntryRel);
    }

    public void addAccountGroupAccountEntryRels(long accountGroupId, long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.addAccountGroupAccountEntryRel(accountGroupId, accountEntryId);
        }
    }

    public void deleteAccountGroupAccountEntryRels(long accountGroupId, long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.accountGroupAccountEntryRelPersistence.removeByAGI_AEI(accountGroupId, accountEntryId);
        }
    }

    public AccountGroupAccountEntryRel fetchAccountGroupAccountEntryRel(long accountGroupId, long accountEntryId) {
        return this.accountGroupAccountEntryRelPersistence.fetchByAGI_AEI(accountGroupId, accountEntryId);
    }

    public List<AccountGroupAccountEntryRel> getAccountGroupAccountEntryRelsByAccountEntryId(long accountEntryId) {
        return this.accountGroupAccountEntryRelPersistence.findByAccountEntryId(accountEntryId);
    }

    public List<AccountGroupAccountEntryRel> getAccountGroupAccountEntryRelsByAccountGroupId(long accountGroupId) {
        return this.accountGroupAccountEntryRelPersistence.findByAccountGroupId(accountGroupId);
    }

    public long getAccountGroupAccountEntryRelsCountByAccountGroupId(long accountGroupId) {
        return this.accountGroupAccountEntryRelPersistence.countByAccountGroupId(accountGroupId);
    }
}

