/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.configuration.AccountEntryEmailDomainsConfiguration;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.exception.DuplicateAccountEntryIdException;
import com.liferay.account.exception.DuplicateAccountEntryUserRelException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.base.AccountEntryUserRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntryUserRel"}, service={AopService.class})
public class AccountEntryUserRelLocalServiceImpl
extends AccountEntryUserRelLocalServiceBaseImpl {
    @Reference
    protected AccountEntryLocalService accountEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryUserRelLocalServiceImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, accountUserId);
        if (accountEntryUserRel != null) {
            throw new DuplicateAccountEntryUserRelException();
        }
        if (accountEntryId != 0L) {
            this.accountEntryLocalService.getAccountEntry(accountEntryId);
        }
        User user = this.userLocalService.getUser(accountUserId);
        this._validateEmailAddress(user.getCompanyId(), accountEntryId, user.getEmailAddress());
        accountEntryUserRel = this.createAccountEntryUserRel(this.counterLocalService.increment());
        accountEntryUserRel.setAccountEntryId(accountEntryId);
        accountEntryUserRel.setAccountUserId(accountUserId);
        return this.addAccountEntryUserRel(accountEntryUserRel);
    }

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId) throws PortalException {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (accountEntryId != 0L) {
            AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntry(accountEntryId);
            companyId = accountEntry.getCompanyId();
        }
        this._validateEmailAddress(companyId, accountEntryId, emailAddress);
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        boolean male = true;
        int birthdayMonth = Month.JANUARY.getValue();
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = null;
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = null;
        User user = this.userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        return this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, user.getUserId());
    }

    public void addAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        for (long accountUserId : accountUserIds) {
            this.addAccountEntryUserRel(accountEntryId, accountUserId);
        }
    }

    public AccountEntryUserRel addPersonTypeAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntry(accountEntryId);
        if (!Objects.equals("person", accountEntry.getType())) {
            throw new AccountEntryTypeException();
        }
        this.deleteAccountEntryUserRelsByAccountEntryId(accountEntryId);
        return this.addAccountEntryUserRel(accountEntryId, creatorUserId, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId);
    }

    public void deleteAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        for (long accountUserId : accountUserIds) {
            this.accountEntryUserRelPersistence.removeByAEI_AUI(accountEntryId, accountUserId);
        }
    }

    public void deleteAccountEntryUserRelsByAccountEntryId(long accountEntryId) {
        for (AccountEntryUserRel accountEntryUserRel : this.getAccountEntryUserRelsByAccountEntryId(accountEntryId)) {
            this.deleteAccountEntryUserRel(accountEntryUserRel);
        }
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId) {
        return this.accountEntryUserRelPersistence.findByAEI(accountEntryId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountUserId(long accountUserId) {
        return this.accountEntryUserRelPersistence.findByAUI(accountUserId);
    }

    public long getAccountEntryUserRelsCountByAccountEntryId(long accountEntryId) {
        return this.accountEntryUserRelPersistence.countByAEI(accountEntryId);
    }

    public boolean hasAccountEntryUserRel(long accountEntryId, long userId) {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, userId);
        return accountEntryUserRel != null;
    }

    public void setPersonTypeAccountEntryUser(long accountEntryId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntry(accountEntryId);
        if (!Objects.equals("person", accountEntry.getType())) {
            throw new AccountEntryTypeException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating user for person account entry: " + accountEntryId));
        }
        ArrayList<AccountEntryUserRel> removeAccountEntryUserRels = new ArrayList<AccountEntryUserRel>(this.getAccountEntryUserRelsByAccountEntryId(accountEntryId));
        boolean currentAccountUser = removeAccountEntryUserRels.removeIf(accountEntryUserRel -> accountEntryUserRel.getAccountUserId() == userId);
        removeAccountEntryUserRels.forEach(accountEntryUserRel -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing user: " + accountEntryUserRel.getAccountUserId()));
            }
            this.deleteAccountEntryUserRel((AccountEntryUserRel)accountEntryUserRel);
        });
        if (userId > 0L && !currentAccountUser) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding user: " + userId));
            }
            this.addAccountEntryUserRel(accountEntryId, userId);
        }
    }

    public void updateAccountEntryUserRels(long[] addAccountEntryIds, long[] deleteAccountEntryIds, long accountUserId) throws PortalException {
        Set set = SetUtil.intersect((long[])addAccountEntryIds, (long[])deleteAccountEntryIds);
        if (SetUtil.isNotEmpty((Set)set)) {
            throw new DuplicateAccountEntryIdException();
        }
        for (long addAccountEntryId : addAccountEntryIds) {
            if (this.hasAccountEntryUserRel(addAccountEntryId, accountUserId)) continue;
            this.addAccountEntryUserRel(addAccountEntryId, accountUserId);
        }
        for (long deleteAccountEntryId : deleteAccountEntryIds) {
            if (!this.hasAccountEntryUserRel(deleteAccountEntryId, accountUserId)) continue;
            this.accountEntryUserRelPersistence.removeByAEI_AUI(deleteAccountEntryId, accountUserId);
        }
    }

    private void _validateEmailAddress(long companyId, long accountEntryId, String emailAddress) throws PortalException {
        long userId = GuestOrUserUtil.getGuestOrUserId();
        List accountEntryUserRels = this.accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(userId);
        if (ListUtil.isEmpty((List)accountEntryUserRels)) {
            return;
        }
        int index = (emailAddress = StringUtil.toLowerCase((String)emailAddress.trim())).indexOf(64);
        if (index == -1) {
            return;
        }
        String domain = emailAddress.substring(index + 1);
        AccountEntryEmailDomainsConfiguration accountEntryEmailDomainsConfiguration = (AccountEntryEmailDomainsConfiguration)this._configurationProvider.getCompanyConfiguration(AccountEntryEmailDomainsConfiguration.class, companyId);
        Object[] blockedDomains = StringUtil.split((String)accountEntryEmailDomainsConfiguration.blockedEmailDomains(), (String)"\r\n");
        if (ArrayUtil.contains((Object[])blockedDomains, (Object)domain)) {
            throw new UserEmailAddressException.MustNotUseBlockedDomain(emailAddress, StringUtil.merge((Object[])blockedDomains, (String)", "));
        }
        if (!accountEntryEmailDomainsConfiguration.enableEmailDomainValidation()) {
            return;
        }
        AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntry(accountEntryId);
        Object[] domains = StringUtil.split((String)accountEntry.getDomains());
        if (!ArrayUtil.contains((Object[])domains, (Object)domain)) {
            throw new UserEmailAddressException.MustHaveValidDomain(emailAddress, accountEntry.getDomains());
        }
    }
}

