/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.exception.AccountEntryDomainsException;
import com.liferay.account.exception.AccountEntryNameException;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.base.AccountEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.validator.routines.DomainValidator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntry"}, service={AopService.class})
public class AccountEntryLocalServiceImpl
extends AccountEntryLocalServiceBaseImpl {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserFileUploadsSettings _userFileUploadsSettings;

    public void activateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::activateAccountEntry));
    }

    public AccountEntry activateAccountEntry(AccountEntry accountEntry) {
        return this.updateStatus(accountEntry, 0);
    }

    public AccountEntry activateAccountEntry(long accountEntryId) throws Exception {
        return this.activateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, int status) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, logoBytes, null, "business", status, null);
    }

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, int status, ServiceContext serviceContext) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, logoBytes, null, "business", status, serviceContext);
    }

    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        long accountEntryId = this.counterLocalService.increment();
        AccountEntry accountEntry = this.accountEntryPersistence.create(accountEntryId);
        User user = this.userLocalService.getUser(userId);
        accountEntry.setCompanyId(user.getCompanyId());
        accountEntry.setUserId(user.getUserId());
        accountEntry.setUserName(user.getFullName());
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)AccountEntry.class.getName(), (String)"name");
        name = StringUtil.shorten((String)name, (int)nameMaxLength);
        this._validateName(name);
        accountEntry.setName(name);
        accountEntry.setDescription(description);
        domains = this._validateDomains(domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        this._portal.updateImageId((BaseModel)accountEntry, true, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        this._validateType(type);
        accountEntry.setType(type);
        accountEntry.setStatus(status);
        accountEntry = (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
        this.groupLocalService.addGroup(userId, 0L, AccountEntry.class.getName(), accountEntryId, 0L, this.getLocalizationMap(name), null, 3, false, 0, null, false, true, null);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AccountEntry.class.getName(), accountEntryId, false, false, false);
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
        }
        return accountEntry;
    }

    public void deactivateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::deactivateAccountEntry));
    }

    public AccountEntry deactivateAccountEntry(AccountEntry accountEntry) {
        return this.updateStatus(accountEntry, 5);
    }

    public AccountEntry deactivateAccountEntry(long accountEntryId) throws Exception {
        return this.deactivateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public void deleteAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)arg_0 -> ((AccountEntryLocalService)this.accountEntryLocalService).deleteAccountEntry(arg_0)));
    }

    public void deleteAccountEntriesByCompanyId(long companyId) {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            throw new UnsupportedOperationException("Deleting account entries by company must be called when deleting a company");
        }
        for (AccountEntry accountRole : this.accountEntryPersistence.findByCompanyId(companyId)) {
            this.accountEntryPersistence.remove((BaseModel)accountRole);
        }
    }

    @Override
    public AccountEntry deleteAccountEntry(AccountEntry accountEntry) throws PortalException {
        accountEntry = super.deleteAccountEntry(accountEntry);
        this.groupLocalService.deleteGroup(accountEntry.getAccountEntryGroup());
        this.resourceLocalService.deleteResource(accountEntry.getCompanyId(), AccountEntry.class.getName(), 4, accountEntry.getAccountEntryId());
        this.assetEntryLocalService.deleteEntry(AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        return accountEntry;
    }

    @Override
    public AccountEntry deleteAccountEntry(long accountEntryId) throws PortalException {
        return this.deleteAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) {
        return this.accountEntryPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getAccountEntriesCount(long companyId, int status) {
        return this.accountEntryPersistence.countByC_S(companyId, status);
    }

    public BaseModelSearchResult<AccountEntry> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, keywords, params, cur, delta, orderByField, reverse));
        SearchHits searchHits = searchResponse.getSearchHits();
        List accountEntries = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long accountEntryId = document.getLong("entryClassPK");
            AccountEntry accountEntry = this.fetchAccountEntry(accountEntryId);
            if (accountEntry == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(AccountEntry.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return accountEntry;
        });
        return new BaseModelSearchResult(accountEntries, searchResponse.getTotalHits());
    }

    @Deprecated
    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, byte[] logoBytes, int status) throws PortalException {
        return this.updateAccountEntry(accountEntryId, parentAccountEntryId, name, description, deleteLogo, domains, logoBytes, null, status, null);
    }

    @Deprecated
    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, byte[] logoBytes, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateAccountEntry(accountEntryId, parentAccountEntryId, name, description, deleteLogo, domains, logoBytes, null, status, serviceContext);
    }

    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = (AccountEntry)this.accountEntryPersistence.fetchByPrimaryKey((Serializable)accountEntryId);
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        this._validateName(name);
        accountEntry.setName(name);
        accountEntry.setDescription(description);
        domains = this._validateDomains(domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        this._portal.updateImageId((BaseModel)accountEntry, !deleteLogo, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        accountEntry.setStatus(status);
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
        }
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    public AccountEntry updateStatus(AccountEntry accountEntry, int status) {
        accountEntry.setStatus(status);
        return this.updateAccountEntry(accountEntry);
    }

    private SearchRequest _getSearchRequest(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{AccountEntry.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, companyId, keywords, params));
        if (cur != -1) {
            searchRequestBuilder.from(Integer.valueOf(cur));
            searchRequestBuilder.size(Integer.valueOf(delta));
        }
        if (Validator.isNotNull((String)orderByField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(AccountEntry.class.getName(), orderByField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    private void _performActions(long[] accountEntryIds, ActionableDynamicQuery.PerformActionMethod<AccountEntry> performActionMethod) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.in((String)"accountEntryId", (Object[])ArrayUtil.toArray((long[])accountEntryIds))));
        actionableDynamicQuery.setPerformActionMethod(performActionMethod);
        actionableDynamicQuery.performActions();
    }

    private void _populateSearchContext(SearchContext searchContext, long companyId, String keywords, LinkedHashMap<String, Object> params) {
        long parentAccountEntryId;
        long[] organizationIds;
        Object[] domains;
        long[] accountUserIds;
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (MapUtil.isEmpty(params)) {
            return;
        }
        long[] accountGroupIds = (long[])params.get("accountGroupIds");
        if (ArrayUtil.isNotEmpty((long[])accountGroupIds)) {
            searchContext.setAttribute("accountGroupIds", (Serializable)accountGroupIds);
        }
        if (ArrayUtil.isNotEmpty((long[])(accountUserIds = (long[])params.get("accountUserIds")))) {
            searchContext.setAttribute("accountUserIds", (Serializable)accountUserIds);
        }
        if (ArrayUtil.isNotEmpty((Object[])(domains = (String[])params.get("domains")))) {
            searchContext.setAttribute("domains", (Serializable)domains);
        }
        if (ArrayUtil.isNotEmpty((long[])(organizationIds = (long[])params.get("organizationIds")))) {
            searchContext.setAttribute("organizationIds", (Serializable)organizationIds);
        }
        if ((parentAccountEntryId = GetterUtil.getLong((Object)params.get("parentAccountEntryId"), (long)-1L)) != -1L) {
            searchContext.setAttribute("parentAccountEntryId", (Serializable)Long.valueOf(parentAccountEntryId));
        }
        int status = GetterUtil.getInteger((Object)params.get("status"), (int)0);
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        String type = (String)params.get("type");
        if (Validator.isNotNull((String)type)) {
            searchContext.setAttribute("type", (Serializable)((Object)type));
        }
    }

    private void _updateAsset(AccountEntry accountEntry, ServiceContext serviceContext) throws PortalException {
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this.assetEntryLocalService.updateEntry(serviceContext.getUserId(), company.getGroupId(), accountEntry.getCreateDate(), accountEntry.getModifiedDate(), AccountEntry.class.getName(), accountEntry.getAccountEntryId(), null, 0L, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, null, null, null, accountEntry.getName(), accountEntry.getDescription(), null, null, null, 0, 0, null);
    }

    private String[] _validateDomains(String[] domains) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])domains)) {
            return domains;
        }
        DomainValidator domainValidator = DomainValidator.getInstance();
        for (String domain : domains) {
            if (domainValidator.isValid(domain)) continue;
            throw new AccountEntryDomainsException();
        }
        return ArrayUtil.distinct((String[])domains);
    }

    private void _validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AccountEntryNameException();
        }
    }

    private void _validateType(String type) throws PortalException {
        if (!ArrayUtil.contains((Object[])AccountConstants.ACCOUNT_ENTRY_TYPES, (Object)type)) {
            throw new AccountEntryTypeException();
        }
    }
}

