/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermission;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.account.model.AccountEntry"}, service={ModelResourcePermission.class})
public class AccountEntryModelResourcePermission
implements ModelResourcePermission<AccountEntry> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private OrganizationPermission _organizationPermission;
    @Reference(target="(resource.name=com.liferay.account)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, AccountEntry accountEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntry.getAccountEntryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AccountEntry accountEntry, String actionId) throws PortalException {
        return this.contains(permissionChecker, accountEntry.getAccountEntryId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountEntryId, String actionId) throws PortalException {
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId);
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
            Organization organization = this._organizationLocalService.fetchOrganization(accountEntryOrganizationRel.getOrganizationId());
            if (organization == null) continue;
            if (permissionChecker.hasPermission(organization.getGroupId(), AccountEntry.class.getName(), accountEntryId, actionId)) {
                return true;
            }
            while (!organization.isRoot()) {
                Organization parentOrganization = organization.getParentOrganization();
                if (this._organizationPermission.contains(permissionChecker, parentOrganization, "MANAGE_SUBORGANIZATIONS_ACCOUNTS") && permissionChecker.hasPermission(parentOrganization.getGroupId(), AccountEntry.class.getName(), accountEntryId, actionId)) {
                    return true;
                }
                organization = parentOrganization;
            }
        }
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        return permissionChecker.hasPermission(accountEntry.getAccountEntryGroupId(), AccountEntry.class.getName(), accountEntryId, actionId);
    }

    public String getModelName() {
        return AccountEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

