/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Organization"}, service={ModelPreFilterContributor.class})
public class OrganizationModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        LinkedHashMap params;
        long[] accountEntryIds = (long[])searchContext.getAttribute("accountEntryIds");
        if (ArrayUtil.isNotEmpty((long[])accountEntryIds)) {
            if (accountEntryIds.length == 1 && accountEntryIds[0] == -1L) {
                ExistsFilter existsFilter = new ExistsFilter("accountEntryIds");
                booleanFilter.add((Filter)existsFilter, BooleanClauseOccur.MUST);
            } else {
                TermsFilter termsFilter = new TermsFilter("accountEntryIds");
                termsFilter.addValues(ArrayUtil.toStringArray((long[])accountEntryIds));
                booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
            }
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) == null) {
            return;
        }
        List accountsOrgsTree = (List)params.get("accountsOrgsTree");
        if (accountsOrgsTree != null) {
            BooleanFilter treePathBooleanFilter = new BooleanFilter();
            if (accountsOrgsTree.isEmpty()) {
                TermQueryImpl termQuery = new TermQueryImpl("treePath", "");
                treePathBooleanFilter.add((Filter)new QueryFilter((Query)termQuery));
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            for (Organization organization : accountsOrgsTree) {
                String treePath;
                try {
                    treePath = organization.buildTreePath();
                    if (permissionChecker != null && OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS_ACCOUNTS")) {
                        treePath = treePath + "*";
                    }
                }
                catch (PortalException portalException) {
                    throw new RuntimeException(portalException);
                }
                WildcardQueryImpl wildcardQuery = new WildcardQueryImpl("treePath", treePath);
                treePathBooleanFilter.add((Filter)new QueryFilter((Query)wildcardQuery));
            }
            booleanFilter.add((Filter)treePathBooleanFilter, BooleanClauseOccur.MUST);
        }
    }
}

