/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.model.AccountGroupAccountEntryRelModel;
import com.liferay.account.retriever.AccountUserRetriever;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountGroupAccountEntryRelLocalService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.account.model.AccountEntry"}, service={ModelDocumentContributor.class})
public class AccountEntryModelDocumentContributor
implements ModelDocumentContributor<AccountEntry> {
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountGroupAccountEntryRelLocalService _accountGroupAccountEntryRelLocalService;
    @Reference
    private AccountUserRetriever _accountUserRetriever;

    public void contribute(Document document, AccountEntry accountEntry) {
        document.addText("description", accountEntry.getDescription());
        document.addText("name", accountEntry.getName());
        document.addKeyword("status", accountEntry.getStatus());
        document.addKeyword("type", accountEntry.getType());
        document.addKeyword("accountGroupIds", this._getAccountGroupIds(accountEntry));
        document.addKeyword("accountUserIds", this._getAccountUserIds(accountEntry));
        document.addKeyword("domains", this._getDomains(accountEntry));
        document.addKeyword("organizationIds", this._getOrganizationIds(accountEntry));
        document.addKeyword("parentAccountEntryId", accountEntry.getParentAccountEntryId());
    }

    private long[] _getAccountGroupIds(AccountEntry accountEntry) {
        return ListUtil.toLongArray((List)this._accountGroupAccountEntryRelLocalService.getAccountGroupAccountEntryRelsByAccountEntryId(accountEntry.getAccountEntryId()), AccountGroupAccountEntryRelModel::getAccountGroupId);
    }

    private long[] _getAccountUserIds(AccountEntry accountEntry) {
        return ListUtil.toLongArray((List)this._accountUserRetriever.getAccountUsers(accountEntry.getAccountEntryId()), (Accessor)User.USER_ID_ACCESSOR);
    }

    private String[] _getDomains(AccountEntry accountEntry) {
        return ArrayUtil.toStringArray((Collection)StringUtil.split((String)accountEntry.getDomains(), (char)','));
    }

    private long[] _getOrganizationIds(AccountEntry accountEntry) {
        return ListUtil.toLongArray((List)this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId()), AccountEntryOrganizationRelModel::getOrganizationId);
    }
}

