/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;

    public void onAfterRemove(Company company) throws ModelListenerException {
        super.onAfterRemove((BaseModel)company);
        this._accountRoleLocalService.deleteAccountRolesByCompanyId(company.getCompanyId());
        try {
            this._deleteAccountGroups(company);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeRemove(Company company) throws ModelListenerException {
        super.onAfterRemove((BaseModel)company);
        this._accountEntryLocalService.deleteAccountEntriesByCompanyId(company.getCompanyId());
    }

    private void _deleteAccountGroups(Company company) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._accountGroupLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)company.getCompanyId())));
        actionableDynamicQuery.setPerformActionMethod(accountGroup -> this._accountGroupLocalService.deleteAccountGroup((AccountGroup)accountGroup));
        actionableDynamicQuery.performActions();
    }
}

