/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.instance.lifecycle;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddDefaultAccountRolesPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Map<String, String[]> _accountAdministratorResourceActionsMap = HashMapBuilder.put((Object)"com.liferay.account", (Object)new String[]{"ADD_ACCOUNT_ENTRY"}).put((Object)AccountEntry.class.getName(), (Object)new String[]{"UPDATE", "MANAGE_USERS", "VIEW_USERS"}).build();
    private static final Map<String, String[]> _accountManagerResourceActionsMap = HashMapBuilder.put((Object)AccountEntry.class.getName(), (Object)new String[]{"MANAGE_ORGANIZATIONS", "VIEW_ORGANIZATIONS", "VIEW_USERS", "MANAGE_USERS", "UPDATE"}).put((Object)"com_liferay_account_admin_web_internal_portlet_AccountEntriesAdminPortlet", (Object)new String[]{"ACCESS_IN_CONTROL_PANEL"}).put((Object)"com_liferay_account_admin_web_internal_portlet_AccountUsersAdminPortlet", (Object)new String[]{"ASSIGN_ACCOUNTS", "ACCESS_IN_CONTROL_PANEL"}).put((Object)Organization.class.getName(), (Object)new String[]{"MANAGE_ACCOUNTS", "MANAGE_SUBORGANIZATIONS_ACCOUNTS"}).build();
    private static final Map<String, String[]> _accountMemberResourceActionsMap = HashMapBuilder.put((Object)AccountEntry.class.getName(), (Object)new String[]{"VIEW"}).build();
    private static final Map<String, Map<Locale, String>> _roleDescriptionsMaps = HashMapBuilder.put((Object)"Account Administrator", Collections.singletonMap(LocaleUtil.US, "Account Administrators are super users of their account.")).put((Object)"Account Manager", Collections.singletonMap(LocaleUtil.US, "Account Managers who belong to an organization can administer all accounts associated to that organization.")).put((Object)"Account Member", Collections.singletonMap(LocaleUtil.US, "All users who belong to an account have this role within that account.")).build();
    @Reference(target="(javax.portlet.name=com_liferay_account_admin_web_internal_portlet_AccountEntriesAdminPortlet)")
    private Portlet _accountEntriesAdminPortlet;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference(target="(javax.portlet.name=com_liferay_account_admin_web_internal_portlet_AccountUsersAdminPortlet)")
    private Portlet _accountUsersAdminPortlet;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.account.service)(&(release.schema.version>=1.0.2)))")
    private Release _release;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        AccountRole accountRole;
        long companyId = company.getCompanyId();
        User defaultUser = company.getDefaultUser();
        if (!this._exists(companyId, "Account Member")) {
            accountRole = this._addAccountRole(defaultUser.getUserId(), "Account Member");
            this._addResourcePermissions(accountRole.getRoleId(), _accountMemberResourceActionsMap);
        }
        if (!this._exists(companyId, "Account Administrator")) {
            accountRole = this._addAccountRole(defaultUser.getUserId(), "Account Administrator");
            this._addResourcePermissions(accountRole.getRoleId(), _accountMemberResourceActionsMap);
            this._addResourcePermissions(accountRole.getRoleId(), _accountAdministratorResourceActionsMap);
        }
        if (!this._exists(companyId, "Account Manager")) {
            Role role = this._roleLocalService.addRole(defaultUser.getUserId(), null, 0L, "Account Manager", null, _roleDescriptionsMaps.get("Account Manager"), 3, null, null);
            this._addResourcePermissions(role.getRoleId(), _accountMemberResourceActionsMap);
            this._addResourcePermissions(role.getRoleId(), _accountManagerResourceActionsMap);
        }
    }

    private AccountRole _addAccountRole(long userId, String roleName) throws Exception {
        AccountRole accountRole = this._accountRoleLocalService.createAccountRole(this._counterLocalService.increment());
        Role role = this._roleLocalService.addRole(userId, AccountRole.class.getName(), accountRole.getAccountRoleId(), roleName, null, _roleDescriptionsMaps.get(roleName), 6, null, null);
        accountRole.setCompanyId(role.getCompanyId());
        accountRole.setAccountEntryId(0L);
        accountRole.setRoleId(role.getRoleId());
        return this._accountRoleLocalService.addAccountRole(accountRole);
    }

    private void _addResourcePermissions(long roleId, Map<String, String[]> resourceActionsMap) throws Exception {
        for (Map.Entry<String, String[]> entry : resourceActionsMap.entrySet()) {
            for (String resourceAction : entry.getValue()) {
                String resourceName = entry.getKey();
                this._resourcePermissionLocalService.addResourcePermission(CompanyThreadLocal.getCompanyId().longValue(), resourceName, 3, "0", roleId, resourceAction);
            }
        }
    }

    private void _checkRoleDescription(Role role) {
        if (MapUtil.isEmpty((Map)role.getDescriptionMap())) {
            role.setDescriptionMap(_roleDescriptionsMaps.get(role.getName()));
            this._roleLocalService.updateRole(role);
        }
    }

    private boolean _exists(long companyId, String roleName) {
        Role role = this._roleLocalService.fetchRole(companyId, roleName);
        if (role != null) {
            this._checkRoleDescription(role);
            return true;
        }
        return false;
    }
}

