/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.account.service.base;

import com.liferay.account.model.AccountGroupAccountEntryRel;
import com.liferay.account.service.AccountGroupAccountEntryRelService;
import com.liferay.account.service.AccountGroupAccountEntryRelServiceUtil;
import com.liferay.account.service.persistence.AccountGroupAccountEntryRelPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;

import java.sql.Connection;

import javax.sql.DataSource;

import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the account group account entry rel remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.account.service.impl.AccountGroupAccountEntryRelServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.account.service.impl.AccountGroupAccountEntryRelServiceImpl
 * @generated
 */
public abstract class AccountGroupAccountEntryRelServiceBaseImpl
	extends BaseServiceImpl
	implements AccountGroupAccountEntryRelService, AopService,
			   IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>AccountGroupAccountEntryRelService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>AccountGroupAccountEntryRelServiceUtil</code>.
	 */
	@Deactivate
	protected void deactivate() {
		AccountGroupAccountEntryRelServiceUtil.setService(null);
	}

	@Override
	public Class<?>[] getAopInterfaces() {
		return new Class<?>[] {
			AccountGroupAccountEntryRelService.class,
			IdentifiableOSGiService.class
		};
	}

	@Override
	public void setAopProxy(Object aopProxy) {
		accountGroupAccountEntryRelService =
			(AccountGroupAccountEntryRelService)aopProxy;

		AccountGroupAccountEntryRelServiceUtil.setService(
			accountGroupAccountEntryRelService);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return AccountGroupAccountEntryRelService.class.getName();
	}

	protected Class<?> getModelClass() {
		return AccountGroupAccountEntryRel.class;
	}

	protected String getModelClassName() {
		return AccountGroupAccountEntryRel.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource =
			accountGroupAccountEntryRelPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@Reference
	protected
		com.liferay.account.service.AccountGroupAccountEntryRelLocalService
			accountGroupAccountEntryRelLocalService;

	protected AccountGroupAccountEntryRelService
		accountGroupAccountEntryRelService;

	@Reference
	protected AccountGroupAccountEntryRelPersistence
		accountGroupAccountEntryRelPersistence;

	@Reference
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		AccountGroupAccountEntryRelServiceBaseImpl.class);

}