/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.account.model.impl;

import com.liferay.account.model.AccountGroupAccountEntryRel;
import com.liferay.account.service.AccountGroupAccountEntryRelLocalServiceUtil;

/**
 * The extended model base implementation for the AccountGroupAccountEntryRel service. Represents a row in the &quot;AccountGroupAccountEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AccountGroupAccountEntryRelImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountGroupAccountEntryRelImpl
 * @see AccountGroupAccountEntryRel
 * @generated
 */
public abstract class AccountGroupAccountEntryRelBaseImpl
	extends AccountGroupAccountEntryRelModelImpl
	implements AccountGroupAccountEntryRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a account group account entry rel model instance should use the <code>AccountGroupAccountEntryRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AccountGroupAccountEntryRelLocalServiceUtil.
				addAccountGroupAccountEntryRel(this);
		}
		else {
			AccountGroupAccountEntryRelLocalServiceUtil.
				updateAccountGroupAccountEntryRel(this);
		}
	}

}