/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class AccountRoleServiceUtil {
    private static final Snapshot<AccountRoleService> _serviceSnapshot = new Snapshot(AccountRoleServiceUtil.class, AccountRoleService.class);

    public static AccountRole addAccountRole(String externalReferenceCode, long accountEntryId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) throws PortalException {
        return AccountRoleServiceUtil.getService().addAccountRole(externalReferenceCode, accountEntryId, name, titleMap, descriptionMap);
    }

    public static void associateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountRoleServiceUtil.getService().associateUser(accountEntryId, accountRoleId, userId);
    }

    public static void associateUser(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        AccountRoleServiceUtil.getService().associateUser(accountEntryId, accountRoleIds, userId);
    }

    public static AccountRole deleteAccountRole(AccountRole accountRole) throws PortalException {
        return AccountRoleServiceUtil.getService().deleteAccountRole(accountRole);
    }

    public static AccountRole deleteAccountRole(long accountRoleId) throws PortalException {
        return AccountRoleServiceUtil.getService().deleteAccountRole(accountRoleId);
    }

    public static AccountRole getAccountRoleByRoleId(long roleId) throws PortalException {
        return AccountRoleServiceUtil.getService().getAccountRoleByRoleId(roleId);
    }

    public static String getOSGiServiceIdentifier() {
        return AccountRoleServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static BaseModelSearchResult<AccountRole> searchAccountRoles(long companyId, long[] accountEntryIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return AccountRoleServiceUtil.getService().searchAccountRoles(companyId, accountEntryIds, keywords, params, start, end, orderByComparator);
    }

    public static void setUserAccountRoles(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        AccountRoleServiceUtil.getService().setUserAccountRoles(accountEntryId, accountRoleIds, userId);
    }

    public static void unassociateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountRoleServiceUtil.getService().unassociateUser(accountEntryId, accountRoleId, userId);
    }

    public static AccountRoleService getService() {
        return (AccountRoleService)_serviceSnapshot.get();
    }
}

