/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionConnectionListener;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionKeepAliveRunner;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import java.time.Duration;

public class KeepAliveSubscriptionConnectionListener
implements ApolloSubscriptionConnectionListener {
    protected final ApolloSubscriptionKeepAliveRunner keepAliveRunner;

    public KeepAliveSubscriptionConnectionListener() {
        this(Duration.ofSeconds(15L));
    }

    public KeepAliveSubscriptionConnectionListener(Duration keepAliveInterval) {
        this.keepAliveRunner = new ApolloSubscriptionKeepAliveRunner(keepAliveInterval);
    }

    @Override
    public void onConnect(SubscriptionSession session, OperationMessage message) {
        this.keepAliveRunner.keepAlive(session);
    }

    @Override
    public void onStart(SubscriptionSession session, OperationMessage message) {
    }

    @Override
    public void onStop(SubscriptionSession session, OperationMessage message) {
    }

    @Override
    public void onTerminate(SubscriptionSession session, OperationMessage message) {
        this.keepAliveRunner.abort(session);
    }

    @Override
    public void shutdown() {
        this.keepAliveRunner.shutdown();
    }
}

