/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.config;

import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.config.GraphQLBuilderConfigurer;
import graphql.kickstart.execution.config.GraphQLSchemaProvider;
import graphql.schema.GraphQLSchema;
import java.util.function.Supplier;
import lombok.Generated;

public class GraphQLBuilder {
    private Supplier<ExecutionStrategyProvider> executionStrategyProviderSupplier = DefaultExecutionStrategyProvider::new;
    private Supplier<PreparsedDocumentProvider> preparsedDocumentProviderSupplier = () -> NoOpPreparsedDocumentProvider.INSTANCE;
    private Supplier<Instrumentation> instrumentationSupplier = () -> SimpleInstrumentation.INSTANCE;
    private Supplier<GraphQLBuilderConfigurer> graphQLBuilderConfigurerSupplier = () -> builder -> {};

    public GraphQLBuilder executionStrategyProvider(Supplier<ExecutionStrategyProvider> supplier) {
        if (supplier != null) {
            this.executionStrategyProviderSupplier = supplier;
        }
        return this;
    }

    public GraphQLBuilder preparsedDocumentProvider(Supplier<PreparsedDocumentProvider> supplier) {
        if (supplier != null) {
            this.preparsedDocumentProviderSupplier = supplier;
        }
        return this;
    }

    public GraphQLBuilder instrumentation(Supplier<Instrumentation> supplier) {
        if (supplier != null) {
            this.instrumentationSupplier = supplier;
        }
        return this;
    }

    public GraphQLBuilder graphQLBuilderConfigurer(Supplier<GraphQLBuilderConfigurer> supplier) {
        if (supplier != null) {
            this.graphQLBuilderConfigurerSupplier = supplier;
        }
        return this;
    }

    public GraphQL build(GraphQLSchemaProvider schemaProvider) {
        return this.build(schemaProvider.getSchema());
    }

    public GraphQL build(GraphQLSchema schema) {
        return this.build(schema, this.instrumentationSupplier);
    }

    public GraphQL build(GraphQLSchema schema, Supplier<Instrumentation> configuredInstrumentationSupplier) {
        ExecutionStrategyProvider executionStrategyProvider = this.executionStrategyProviderSupplier.get();
        ExecutionStrategy queryExecutionStrategy = executionStrategyProvider.getQueryExecutionStrategy();
        ExecutionStrategy mutationExecutionStrategy = executionStrategyProvider.getMutationExecutionStrategy();
        ExecutionStrategy subscriptionExecutionStrategy = executionStrategyProvider.getSubscriptionExecutionStrategy();
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema).preparsedDocumentProvider(this.preparsedDocumentProviderSupplier.get());
        if (queryExecutionStrategy != null) {
            builder.queryExecutionStrategy(queryExecutionStrategy);
        }
        if (mutationExecutionStrategy != null) {
            builder.mutationExecutionStrategy(mutationExecutionStrategy);
        }
        if (subscriptionExecutionStrategy != null) {
            builder.subscriptionExecutionStrategy(subscriptionExecutionStrategy);
        }
        Instrumentation instrumentation = configuredInstrumentationSupplier.get();
        builder.instrumentation(instrumentation);
        if (this.containsDispatchInstrumentation(instrumentation)) {
            builder.doNotAddDefaultInstrumentations();
        }
        this.graphQLBuilderConfigurerSupplier.get().configure(builder);
        return builder.build();
    }

    private boolean containsDispatchInstrumentation(Instrumentation instrumentation) {
        if (instrumentation instanceof ChainedInstrumentation) {
            return ((ChainedInstrumentation)instrumentation).getInstrumentations().stream().anyMatch(this::containsDispatchInstrumentation);
        }
        return instrumentation instanceof DataLoaderDispatcherInstrumentation;
    }

    @Generated
    public Supplier<Instrumentation> getInstrumentationSupplier() {
        return this.instrumentationSupplier;
    }
}

