/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution;

import graphql.kickstart.execution.StringUtils;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import java.util.List;
import lombok.Generated;

class OperationNameExtractor {
    static String extractOperationName(String gqlQuery, String requestedOperationName, String defaultIfNotFound) {
        if (StringUtils.isNotEmpty(requestedOperationName)) {
            return requestedOperationName;
        }
        if (StringUtils.isNotEmpty(gqlQuery)) {
            return OperationNameExtractor.parseForOperationName(gqlQuery, defaultIfNotFound);
        }
        return defaultIfNotFound;
    }

    private static String parseForOperationName(String gqlQuery, String defaultIfNotFound) {
        try {
            String name;
            Document document = new Parser().parseDocument(gqlQuery);
            List operations = document.getDefinitionsOfType(OperationDefinition.class);
            if (operations.size() == 1 && StringUtils.isNotEmpty(name = ((OperationDefinition)operations.get(0)).getName())) {
                return name;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return defaultIfNotFound;
    }

    @Generated
    private OperationNameExtractor() {
    }
}

