/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.kickstart.execution.BatchedDataLoaderGraphQLBuilder;
import graphql.kickstart.execution.FutureExecutionResult;
import graphql.kickstart.execution.GraphQLInvokerProxy;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.execution.config.GraphQLBuilder;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLInvoker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLInvoker.class);
    private final GraphQLBuilder graphQLBuilder;
    private final BatchedDataLoaderGraphQLBuilder batchedDataLoaderGraphQLBuilder;
    private final GraphQLInvokerProxy proxy = GraphQL::executeAsync;

    public FutureExecutionResult execute(GraphQLInvocationInput invocationInput) {
        if (invocationInput instanceof GraphQLSingleInvocationInput) {
            return FutureExecutionResult.single(invocationInput, this.executeAsync((GraphQLSingleInvocationInput)invocationInput));
        }
        return FutureExecutionResult.batched(invocationInput, this.executeAsync((GraphQLBatchedInvocationInput)invocationInput));
    }

    public CompletableFuture<ExecutionResult> executeAsync(GraphQLSingleInvocationInput invocationInput) {
        GraphQL graphQL = this.graphQLBuilder.build(invocationInput.getSchema());
        return this.proxy.executeAsync(graphQL, invocationInput.getExecutionInput());
    }

    public GraphQLQueryResult query(GraphQLInvocationInput invocationInput) {
        return this.queryAsync(invocationInput).join();
    }

    public CompletableFuture<GraphQLQueryResult> queryAsync(GraphQLInvocationInput invocationInput) {
        if (invocationInput instanceof GraphQLSingleInvocationInput) {
            return this.executeAsync((GraphQLSingleInvocationInput)invocationInput).thenApply(GraphQLQueryResult::create);
        }
        GraphQLBatchedInvocationInput batchedInvocationInput = (GraphQLBatchedInvocationInput)invocationInput;
        return this.executeAsync(batchedInvocationInput).thenApply(GraphQLQueryResult::create);
    }

    private CompletableFuture<List<ExecutionResult>> executeAsync(GraphQLBatchedInvocationInput batchedInvocationInput) {
        GraphQL graphQL = this.batchedDataLoaderGraphQLBuilder.newGraphQL(batchedInvocationInput, this.graphQLBuilder);
        return this.sequence(batchedInvocationInput.getExecutionInputs().stream().map(executionInput -> this.proxy.executeAsync(graphQL, (ExecutionInput)executionInput)).collect(Collectors.toList()));
    }

    private <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        CompletableFuture[] futuresArray = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futuresArray).thenApply(aVoid -> {
            ArrayList result = new ArrayList(futures.size());
            for (CompletableFuture future : futuresArray) {
                assert (future.isDone());
                result.add(future.join());
            }
            return result;
        });
    }

    @Generated
    public GraphQLInvoker(GraphQLBuilder graphQLBuilder, BatchedDataLoaderGraphQLBuilder batchedDataLoaderGraphQLBuilder) {
        this.graphQLBuilder = graphQLBuilder;
        this.batchedDataLoaderGraphQLBuilder = batchedDataLoaderGraphQLBuilder;
    }
}

