/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class XMLRPCDecoder {
    private static final Class[] Classes = new Class[]{FaultDecoder.class, MethodDecoder.class, ParametersDecoder.class, ArrayDecoder.class, StructureDecoder.class, ValueDecoder.class, IntegerDecoder.class, BooleanDecoder.class, StringDecoder.class, DoubleDecoder.class, DateDecoder.class, Base64Decoder.class};
    private static final Map _decoders = new HashMap();

    static {
        Class[] someClasses = Classes;
        int count = someClasses.length;
        int index = 0;
        while (index < count) {
            Class aClass = someClasses[index];
            try {
                XMLRPCDecoder aDecoder = (XMLRPCDecoder)aClass.newInstance();
                aDecoder.register(_decoders);
            }
            catch (Exception anException) {
                throw new RuntimeException("XMLRPCDecoder.decoders: " + anException);
            }
            ++index;
        }
    }

    protected XMLRPCDecoder() {
    }

    private static Map decoders() {
        return _decoders;
    }

    public static Object decode(Reader aReader) throws Exception {
        if (aReader != null) {
            Map someDecoders = XMLRPCDecoder.decoders();
            XmlPullParserFactory aFactory = XmlPullParserFactory.newInstance();
            XmlPullParser aParser = aFactory.newPullParser();
            aParser.setInput(aReader);
            return XMLRPCDecoder.decode(aParser);
        }
        throw new IllegalArgumentException("XMLRPCDecoder.decode: null reader.");
    }

    private static XMLRPCDecoder decoderWithName(String aName) {
        if (aName != null) {
            return (XMLRPCDecoder)XMLRPCDecoder.decoders().get(aName.toUpperCase());
        }
        throw new IllegalArgumentException("XMLRPCDecoder.decoderWithName: null name.");
    }

    private static Object decode(XmlPullParser aParser) throws Exception {
        if (aParser != null) {
            int anEventType = aParser.getEventType();
            while (anEventType != 1) {
                if (anEventType == 2) {
                    String aName = aParser.getName();
                    XMLRPCDecoder aDecoder = XMLRPCDecoder.decoderWithName(aName);
                    if (aDecoder != null) {
                        return aDecoder.decodeWithParser(aParser);
                    }
                    anEventType = aParser.next();
                    continue;
                }
                anEventType = aParser.next();
            }
            return null;
        }
        throw new IllegalArgumentException("XMLRPCDecoder.decode: null reader.");
    }

    protected abstract String[] names();

    protected void register(Map aMap) {
        if (aMap != null) {
            String[] someNames = this.names();
            if (someNames != null) {
                int count = someNames.length;
                int index = 0;
                while (index < count) {
                    String aName = someNames[index];
                    aMap.put(aName.toUpperCase(), this);
                    ++index;
                }
                return;
            }
            throw new IllegalStateException("XMLRPCDecoder.register: null names.");
        }
        throw new IllegalArgumentException("XMLRPCDecoder.register: null map.");
    }

    protected abstract Object decodeWithParser(XmlPullParser var1) throws Exception;

    public static void main(String[] args) {
        args = new String[]{"http://www.oreillynet.com/meerkat/xml-rpc/server.php"};
        if (args.length == 1) {
            System.out.println("Decoding \"" + args[0] + "\"");
            try {
                URL anURL = new URL(args[0]);
                byte[] aRequest = "<methodCall><methodName>system.listMethods</methodName><params><param><value></value></param></params></methodCall>".getBytes();
                URLConnection aConnection = anURL.openConnection();
                aConnection.setDoInput(true);
                aConnection.setDoOutput(true);
                aConnection.setUseCaches(false);
                aConnection.setAllowUserInteraction(false);
                aConnection.setRequestProperty("Content-Type", "text/xml");
                aConnection.setRequestProperty("Content-Length", Integer.toString(aRequest.length));
                BufferedOutputStream anOutputStream = new BufferedOutputStream(aConnection.getOutputStream());
                ((OutputStream)anOutputStream).write(aRequest);
                ((OutputStream)anOutputStream).flush();
                BufferedInputStream anInputStream = new BufferedInputStream(aConnection.getInputStream());
                InputStreamReader aReader = new InputStreamReader(anInputStream);
                Object anObject = XMLRPCDecoder.decode(aReader);
                System.out.println("anObject: " + anObject.getClass());
                System.out.println("anObject: " + anObject);
            }
            catch (Exception anException) {
                System.err.println(anException);
            }
            return;
        }
        System.out.println("XMLRPCDecoder maps an XML-RPC document into its Java equivalent.");
        System.out.println("This example will send a canned 'system.listMethods' to the target url.");
        System.out.println("Usage: <url>");
        System.out.println("Example: \"http://www.oreillynet.com/meerkat/xml-rpc/server.php\"");
    }

    private static final class ArrayDecoder
    extends XMLRPCDecoder {
        private static final String Name = "array";
        private static final String DataName = "data";
        private static final String[] Names = new String[]{"array"};

        protected ArrayDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                ArrayList<Object> aCollection = new ArrayList<Object>();
                aParser.require(2, null, Name);
                aParser.nextTag();
                aParser.require(2, null, DataName);
                aParser.nextTag();
                while (aParser.getEventType() != 1 && aParser.getEventType() == 2) {
                    Object aValue = XMLRPCDecoder.decode(aParser);
                    aCollection.add(aValue);
                }
                if (aCollection.isEmpty()) {
                    aCollection = null;
                }
                aParser.require(3, null, DataName);
                aParser.nextTag();
                aParser.require(3, null, Name);
                aParser.nextTag();
                return aCollection;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.ArrayDecoder.decodeWithParser: null parser.");
        }
    }

    public static final class Base64 {
        private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        private static byte[] codes = new byte[256];

        static {
            int i = 0;
            while (i < 256) {
                Base64.codes[i] = -1;
                ++i;
            }
            i = 65;
            while (i <= 90) {
                Base64.codes[i] = (byte)(i - 65);
                ++i;
            }
            i = 97;
            while (i <= 122) {
                Base64.codes[i] = (byte)(26 + i - 97);
                ++i;
            }
            i = 48;
            while (i <= 57) {
                Base64.codes[i] = (byte)(52 + i - 48);
                ++i;
            }
            Base64.codes[43] = 62;
            Base64.codes[47] = 63;
        }

        public static byte[] decode(byte[] data) {
            int len = (data.length + 3) / 4 * 3;
            if (data.length > 0 && data[data.length - 1] == 61) {
                --len;
            }
            if (data.length > 1 && data[data.length - 2] == 61) {
                --len;
            }
            byte[] out = new byte[len];
            int shift = 0;
            int accum = 0;
            int index = 0;
            int ix = 0;
            while (ix < data.length) {
                byte value = codes[data[ix] & 0xFF];
                if (value >= 0) {
                    accum <<= 6;
                    accum |= value;
                    if ((shift += 6) >= 8) {
                        out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                    }
                }
                ++ix;
            }
            if (index != out.length) {
                throw new RuntimeException("Error decoding BASE64 element: Miscalculated data length.");
            }
            return out;
        }
    }

    private static final class Base64Decoder
    extends XMLRPCDecoder {
        private static final String Name = "base64";
        private static final String[] Names = new String[]{"base64"};

        protected Base64Decoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                String aString = aParser.nextText();
                byte[] aValue = null;
                if (aString != null) {
                    try {
                        aValue = Base64.decode(aString.getBytes());
                    }
                    catch (Exception anException) {
                        System.err.println(aValue);
                    }
                }
                aParser.require(3, null, Name);
                aParser.nextTag();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.Base64Decoder.decodeWithParser: null parser.");
        }
    }

    private static final class BooleanDecoder
    extends XMLRPCDecoder {
        private static final String Name = "boolean";
        private static final String[] Names = new String[]{"boolean"};
        private static final String False = "0";

        protected BooleanDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                String aString = aParser.nextText();
                Boolean aValue = Boolean.TRUE;
                if (False.equals(aString)) {
                    aValue = Boolean.FALSE;
                }
                aParser.require(3, null, Name);
                aParser.next();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.BooleanDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class DateDecoder
    extends XMLRPCDecoder {
        private static final String Name = "dateTime.iso8601";
        private static final String[] Names = new String[]{"dateTime.iso8601"};
        private static final String Format = "yyyyMMdd'T'HH:mm:ss";

        protected DateDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                String aString = aParser.nextText();
                Date aValue = null;
                if (aString != null) {
                    try {
                        SimpleDateFormat aFormat = new SimpleDateFormat(Format);
                        aValue = aFormat.parse(aString);
                    }
                    catch (Exception anException) {
                        System.err.println(anException);
                    }
                }
                aParser.require(3, null, Name);
                aParser.nextTag();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.DateDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class DoubleDecoder
    extends XMLRPCDecoder {
        private static final String Name = "double";
        private static final String[] Names = new String[]{"double"};

        protected DoubleDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                String aString = aParser.nextText();
                Double aValue = null;
                if (aString != null) {
                    try {
                        aValue = new Double(aString);
                    }
                    catch (Exception anException) {
                        System.err.println(anException);
                    }
                }
                aParser.require(3, null, Name);
                aParser.nextTag();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.DoubleDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class FaultDecoder
    extends XMLRPCDecoder {
        private static final String Name = "fault";
        private static final String[] Names = new String[]{"fault"};
        private static final String FaultStringKey = "faultString";
        private static final String FaultCodeKey = "faultCode";

        protected FaultDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                aParser.nextTag();
                Map aMap = (Map)XMLRPCDecoder.decode(aParser);
                RuntimeException aValue = null;
                if (aMap != null) {
                    String aDescription = (String)aMap.get(FaultStringKey);
                    Number aCode = (Number)aMap.get(FaultCodeKey);
                    aValue = new RuntimeException(String.valueOf(aDescription) + "(" + aCode + ")");
                }
                aParser.require(3, null, Name);
                aParser.nextTag();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.FaultDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class IntegerDecoder
    extends XMLRPCDecoder {
        private static final String IntName = "int";
        private static final String I4Name = "i4";
        private static final String[] Names = new String[]{"int", "i4"};

        protected IntegerDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                String aName = aParser.getName();
                aParser.require(2, null, aName);
                String aString = aParser.nextText();
                Integer aValue = null;
                if (aString != null) {
                    try {
                        aValue = new Integer(aString);
                    }
                    catch (Exception anException) {
                        System.err.println(anException);
                    }
                }
                aParser.require(3, null, aName);
                aParser.nextTag();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.IntegerDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class MethodDecoder
    extends XMLRPCDecoder {
        private static final String Name = "methodCall";
        private static final String[] Names = new String[]{"methodCall"};

        protected MethodDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                aParser.nextTag();
                String aMethodName = aParser.nextText();
                Collection someArguments = (Collection)XMLRPCDecoder.decode(aParser);
                HashMap<String, Object> aValue = new HashMap<String, Object>();
                aValue.put("methodName", aMethodName);
                aValue.put("parameters", someArguments);
                if (aParser.getEventType() != 1) {
                    aParser.require(3, null, Name);
                    aParser.next();
                }
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.MethodDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class ParametersDecoder
    extends XMLRPCDecoder {
        private static final String Name = "params";
        private static final String ParamName = "param";
        private static final String[] Names = new String[]{"params"};

        protected ParametersDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                ArrayList<Object> aCollection = new ArrayList<Object>();
                aParser.require(2, null, Name);
                aParser.nextTag();
                while (aParser.getEventType() != 1 && aParser.getEventType() == 2) {
                    aParser.require(2, null, ParamName);
                    aParser.nextTag();
                    aCollection.add(XMLRPCDecoder.decode(aParser));
                    aParser.require(3, null, ParamName);
                    aParser.nextTag();
                }
                aParser.require(3, null, Name);
                aParser.nextTag();
                if (aCollection.isEmpty()) {
                    aCollection = null;
                }
                return aCollection;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.ParametersDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class StringDecoder
    extends XMLRPCDecoder {
        private static final String Name = "string";
        private static final String[] Names = new String[]{"string"};

        protected StringDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                aParser.require(2, null, Name);
                String aValue = aParser.nextText();
                aParser.require(3, null, Name);
                aParser.next();
                if (aValue != null && aValue.length() == 0) {
                    aValue = null;
                }
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.StringDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class StructureDecoder
    extends XMLRPCDecoder {
        private static final String Name = "struct";
        private static final String MemberName = "member";
        private static final String NameName = "name";
        private static final String[] Names = new String[]{"struct"};

        protected StructureDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                HashMap<String, Object> aMap = new HashMap<String, Object>();
                aParser.require(2, null, Name);
                aParser.nextTag();
                while (aParser.getEventType() != 1 && aParser.getEventType() == 2) {
                    String aKey = null;
                    Object aValue = null;
                    aParser.require(2, null, MemberName);
                    aParser.nextTag();
                    aParser.require(2, null, NameName);
                    aKey = aParser.nextText();
                    aParser.require(3, null, NameName);
                    aValue = XMLRPCDecoder.decode(aParser);
                    aParser.require(3, null, MemberName);
                    aParser.nextTag();
                    if (aKey == null || aValue == null) continue;
                    aMap.put(aKey, aValue);
                }
                aParser.require(3, null, Name);
                aParser.nextTag();
                if (aMap.isEmpty()) {
                    aMap = null;
                }
                return aMap;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.StructureDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class ValueDecoder
    extends XMLRPCDecoder {
        private static final String Name = "value";
        private static final String[] Names = new String[]{"value"};

        protected ValueDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser aParser) throws Exception {
            if (aParser != null) {
                Object aValue = null;
                aParser.require(2, null, Name);
                aParser.next();
                aValue = aParser.getEventType() == 3 ? "" : XMLRPCDecoder.decode(aParser);
                aParser.require(3, null, Name);
                aParser.nextTag();
                return aValue;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.ValueDecoder.decodeWithParser: null parser.");
        }
    }
}

