/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class CloneableFileReader
extends Reader
implements Cloneable {
    FileReader freader;
    String filename;
    long position;

    public CloneableFileReader(String filename) throws FileNotFoundException {
        this.freader = new FileReader(filename);
        this.filename = filename;
    }

    public Object clone() throws CloneNotSupportedException {
        CloneableFileReader clone;
        try {
            clone = new CloneableFileReader(this.filename);
            clone.skip(this.position);
        }
        catch (IOException e) {
            throw new CloneNotSupportedException("could not clone file reader " + e);
        }
        return clone;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int actual = this.freader.read(cbuf, offset, length);
        if (actual > 0) {
            this.position += (long)actual;
        }
        return actual;
    }

    @Override
    public void close() throws IOException {
        this.freader.close();
    }
}

