/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum Privilege {
    BYPASS_ACL("bypass-acl"),
    MODIFY_ACL("modify-acl"),
    CONFIG_READ("config-read"),
    CONFIG_WRITE("config-write"),
    JMX_READ("jmx-read"),
    JMX_WRITE("jmx-write"),
    JMX_NOTIFY("jmx-notify"),
    LDIF_IMPORT("ldif-import"),
    LDIF_EXPORT("ldif-export"),
    BACKEND_BACKUP("backend-backup"),
    BACKEND_RESTORE("backend-restore"),
    SERVER_SHUTDOWN("server-shutdown"),
    SERVER_RESTART("server-restart"),
    PROXIED_AUTH("proxied-auth"),
    DISCONNECT_CLIENT("disconnect-client"),
    CANCEL_REQUEST("cancel-request"),
    PASSWORD_RESET("password-reset"),
    DATA_SYNC("data-sync"),
    UPDATE_SCHEMA("update-schema"),
    PRIVILEGE_CHANGE("privilege-change"),
    UNINDEXED_SEARCH("unindexed-search");

    private static final HashMap<String, Privilege> PRIV_MAP;
    private static final HashSet<Privilege> DEFAULT_ROOT_PRIV_SET;
    private static final HashSet<String> PRIV_NAMES;
    private final String privilegeName;

    private Privilege(String privilegeName) {
        this.privilegeName = privilegeName;
    }

    public String getName() {
        return this.privilegeName;
    }

    public static Privilege privilegeForName(String lowerPrivName) {
        return PRIV_MAP.get(lowerPrivName);
    }

    public String toString() {
        return this.privilegeName;
    }

    public static Set<String> getPrivilegeNames() {
        return PRIV_NAMES;
    }

    public static Set<Privilege> getDefaultRootPrivileges() {
        return DEFAULT_ROOT_PRIV_SET;
    }

    static {
        PRIV_MAP = new HashMap();
        DEFAULT_ROOT_PRIV_SET = new HashSet();
        PRIV_NAMES = new HashSet();
        PRIV_MAP.put("bypass-acl", BYPASS_ACL);
        PRIV_MAP.put("modify-acl", MODIFY_ACL);
        PRIV_MAP.put("config-read", CONFIG_READ);
        PRIV_MAP.put("config-write", CONFIG_WRITE);
        PRIV_MAP.put("jmx-read", JMX_READ);
        PRIV_MAP.put("jmx-write", JMX_WRITE);
        PRIV_MAP.put("jmx-notify", JMX_NOTIFY);
        PRIV_MAP.put("ldif-import", LDIF_IMPORT);
        PRIV_MAP.put("ldif-export", LDIF_EXPORT);
        PRIV_MAP.put("backend-backup", BACKEND_BACKUP);
        PRIV_MAP.put("backend-restore", BACKEND_RESTORE);
        PRIV_MAP.put("server-shutdown", SERVER_SHUTDOWN);
        PRIV_MAP.put("server-restart", SERVER_RESTART);
        PRIV_MAP.put("proxied-auth", PROXIED_AUTH);
        PRIV_MAP.put("disconnect-client", DISCONNECT_CLIENT);
        PRIV_MAP.put("cancel-request", CANCEL_REQUEST);
        PRIV_MAP.put("password-reset", PASSWORD_RESET);
        PRIV_MAP.put("data-sync", DATA_SYNC);
        PRIV_MAP.put("update-schema", UPDATE_SCHEMA);
        PRIV_MAP.put("privilege-change", PRIVILEGE_CHANGE);
        PRIV_MAP.put("unindexed-search", UNINDEXED_SEARCH);
        PRIV_NAMES.add("bypass-acl");
        PRIV_NAMES.add("modify-acl");
        PRIV_NAMES.add("config-read");
        PRIV_NAMES.add("config-write");
        PRIV_NAMES.add("jmx-read");
        PRIV_NAMES.add("jmx-write");
        PRIV_NAMES.add("jmx-notify");
        PRIV_NAMES.add("ldif-import");
        PRIV_NAMES.add("ldif-export");
        PRIV_NAMES.add("backend-backup");
        PRIV_NAMES.add("backend-restore");
        PRIV_NAMES.add("server-shutdown");
        PRIV_NAMES.add("server-restart");
        PRIV_NAMES.add("proxied-auth");
        PRIV_NAMES.add("disconnect-client");
        PRIV_NAMES.add("cancel-request");
        PRIV_NAMES.add("password-reset");
        PRIV_NAMES.add("data-sync");
        PRIV_NAMES.add("update-schema");
        PRIV_NAMES.add("privilege-change");
        PRIV_NAMES.add("unindexed-search");
        DEFAULT_ROOT_PRIV_SET.add(BYPASS_ACL);
        DEFAULT_ROOT_PRIV_SET.add(MODIFY_ACL);
        DEFAULT_ROOT_PRIV_SET.add(CONFIG_READ);
        DEFAULT_ROOT_PRIV_SET.add(CONFIG_WRITE);
        DEFAULT_ROOT_PRIV_SET.add(LDIF_IMPORT);
        DEFAULT_ROOT_PRIV_SET.add(LDIF_EXPORT);
        DEFAULT_ROOT_PRIV_SET.add(BACKEND_BACKUP);
        DEFAULT_ROOT_PRIV_SET.add(BACKEND_RESTORE);
        DEFAULT_ROOT_PRIV_SET.add(SERVER_SHUTDOWN);
        DEFAULT_ROOT_PRIV_SET.add(SERVER_RESTART);
        DEFAULT_ROOT_PRIV_SET.add(DISCONNECT_CLIENT);
        DEFAULT_ROOT_PRIV_SET.add(CANCEL_REQUEST);
        DEFAULT_ROOT_PRIV_SET.add(PASSWORD_RESET);
        DEFAULT_ROOT_PRIV_SET.add(UPDATE_SCHEMA);
        DEFAULT_ROOT_PRIV_SET.add(PRIVILEGE_CHANGE);
        DEFAULT_ROOT_PRIV_SET.add(UNINDEXED_SEARCH);
    }
}

