/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.opends.messages.Message;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEntry {
    private static Map<String, Message> mapClassToTypeName = new HashMap<String, Message>();
    private static Map<String, Message> mapAttrToDisplayName = new HashMap<String, Message>();
    private static Set<String> supAttrNames = new HashSet<String>();
    private String id;
    private String className;
    private String state;
    private String schedStart;
    private String actStart;
    private String compTime;
    private List<String> depends;
    private String depFailAct;
    private List<String> logs;
    private List<String> notifyComp;
    private List<String> notifyErr;
    private DN dn;
    private Task task;
    private Map<Message, List<String>> taskSpecificAttrValues = new HashMap<Message, List<String>>();

    public TaskEntry(Entry entry) {
        this.dn = entry.getDN();
        String p = "ds-task-";
        this.id = this.getSingleStringValue(entry, p + "id");
        this.className = this.getSingleStringValue(entry, p + "class-name");
        this.state = this.getSingleStringValue(entry, p + "state");
        this.schedStart = this.getSingleStringValue(entry, p + "scheduled-start-time");
        this.actStart = this.getSingleStringValue(entry, p + "actual-start-time");
        this.compTime = this.getSingleStringValue(entry, p + "completion-time");
        this.depends = this.getMultiStringValue(entry, p + "dependency-id");
        this.depFailAct = this.getSingleStringValue(entry, p + "failed-dependency-action");
        this.logs = this.getMultiStringValue(entry, p + "log-message");
        this.notifyErr = this.getMultiStringValue(entry, p + "notify-on-error");
        this.notifyComp = this.getMultiStringValue(entry, p + "notify-on-completion");
        Map<AttributeType, List<Attribute>> attrMap = entry.getUserAttributes();
        for (AttributeType type : attrMap.keySet()) {
            String typeName = type.getNormalizedPrimaryName();
            if (supAttrNames.contains(typeName)) continue;
            Message attrTypeName = this.getAttributeDisplayName(type.getNormalizedPrimaryName());
            List<Attribute> attrList = entry.getUserAttribute(type);
            for (Attribute attr : attrList) {
                LinkedHashSet<AttributeValue> valuesSet = attr.getValues();
                for (AttributeValue av : valuesSet) {
                    List<String> valueList = this.taskSpecificAttrValues.get(attrTypeName);
                    if (valueList == null) {
                        valueList = new ArrayList<String>();
                        this.taskSpecificAttrValues.put(attrTypeName, valueList);
                    }
                    valueList.add(av.getStringValue());
                }
            }
        }
    }

    public DN getDN() {
        return this.dn;
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Message getState() {
        TaskState ts;
        Message m = Message.EMPTY;
        if (this.state != null && (ts = TaskState.fromString(this.state)) != null) {
            m = ts.getDisplayName();
        }
        return m;
    }

    public Message getScheduledStartTime() {
        return this.formatTimeString(this.schedStart);
    }

    public Message getActualStartTime() {
        return this.formatTimeString(this.actStart);
    }

    public Message getCompletionTime() {
        return this.formatTimeString(this.compTime);
    }

    public List<String> getDependencyIds() {
        return Collections.unmodifiableList(this.depends);
    }

    public Message getFailedDependencyAction() {
        FailedDependencyAction fda;
        Message m = null;
        if (this.depFailAct != null && (fda = FailedDependencyAction.fromString(this.depFailAct)) != null) {
            m = fda.getDisplayName();
        }
        return m;
    }

    public List<Message> getLogMessages() {
        ArrayList<Message> formattedLogs = new ArrayList<Message>();
        for (String aLog : this.logs) {
            formattedLogs.add(Message.raw(aLog, new Object[0]));
        }
        return Collections.unmodifiableList(formattedLogs);
    }

    public List<String> getCompletionNotificationEmailAddresses() {
        return Collections.unmodifiableList(this.notifyComp);
    }

    public List<String> getErrorNotificationEmailAddresses() {
        return Collections.unmodifiableList(this.notifyErr);
    }

    public Message getType() {
        Message type = Message.EMPTY;
        if (this.className != null) {
            Task task;
            type = mapClassToTypeName.get(this.className);
            if (type == null && (task = this.getTask()) != null) {
                try {
                    Method m = Task.class.getMethod("getDisplayName", new Class[0]);
                    Object oName = m.invoke((Object)task, new Object[0]);
                    if (oName instanceof Message) {
                        mapClassToTypeName.put(this.className, (Message)oName);
                        type = (Message)oName;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (type == null) {
                type = Message.raw(this.className, new Object[0]);
            }
        }
        return type;
    }

    public boolean isCancelable() {
        boolean cancelable = false;
        TaskState state = this.getTaskState();
        if (state != null) {
            Task task = this.getTask();
            cancelable = TaskState.isPending(state) || TaskState.isRunning(state) && task != null && task.isInterruptable();
        }
        return cancelable;
    }

    public Map<Message, List<String>> getTaskSpecificAttributeValuePairs() {
        return this.taskSpecificAttrValues;
    }

    public TaskState getTaskState() {
        TaskState ts = null;
        if (this.state != null) {
            ts = TaskState.fromString(this.state);
        }
        return ts;
    }

    public boolean isDone() {
        TaskState ts = this.getTaskState();
        return ts != null && TaskState.isDone(ts);
    }

    private String getSingleStringValue(Entry entry, String attrName) {
        LinkedHashSet<AttributeValue> values;
        List<Attribute> attrList = entry.getAttribute(attrName);
        if (attrList != null && attrList.size() == 1 && (values = attrList.get(0).getValues()) != null && values.size() == 1) {
            return ((AttributeValue)values.iterator().next()).getStringValue();
        }
        return "";
    }

    private List<String> getMultiStringValue(Entry entry, String attrName) {
        ArrayList<String> valuesList = new ArrayList<String>();
        List<Attribute> attrList = entry.getAttribute(attrName);
        if (attrList != null) {
            for (Attribute attr : attrList) {
                LinkedHashSet<AttributeValue> values = attr.getValues();
                if (values == null) continue;
                for (AttributeValue value : values) {
                    valuesList.add(value.getStringValue());
                }
            }
        }
        return valuesList;
    }

    private Message getAttributeDisplayName(String attrName) {
        Task task;
        Message name = mapAttrToDisplayName.get(attrName);
        if (name == null && (task = this.getTask()) != null) {
            try {
                Method m = Task.class.getMethod("getAttributeDisplayName", String.class);
                Object o = m.invoke((Object)task, attrName);
                if (o != null && Message.class.isAssignableFrom(o.getClass())) {
                    name = (Message)o;
                    mapAttrToDisplayName.put(attrName, name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (name == null) {
            name = Message.raw(attrName, new Object[0]);
        }
        return name;
    }

    private Message formatTimeString(String timeString) {
        Message ret = Message.EMPTY;
        if (timeString != null && timeString.length() > 0) {
            try {
                SimpleDateFormat dateFormat;
                if (timeString.endsWith("Z")) {
                    dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                } else {
                    dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                }
                Date date = dateFormat.parse(timeString);
                DateFormat df = DateFormat.getDateTimeInstance(2, 1);
                String dateString = df.format(date);
                ret = Message.raw(dateString, new Object[0]);
            }
            catch (ParseException pe) {
                ret = Message.raw(timeString, new Object[0]);
            }
        }
        return ret;
    }

    private Task getTask() {
        if (this.task == null && this.className != null) {
            try {
                Class<?> clazz = Class.forName(this.className);
                Object o = clazz.newInstance();
                if (Task.class.isAssignableFrom(o.getClass())) {
                    this.task = (Task)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.task;
    }

    static {
        supAttrNames.add("ds-task-id");
        supAttrNames.add("ds-task-class-name");
        supAttrNames.add("ds-task-state");
        supAttrNames.add("ds-task-scheduled-start-time");
        supAttrNames.add("ds-task-actual-start-time");
        supAttrNames.add("ds-task-completion-time");
        supAttrNames.add("ds-task-dependency-id");
        supAttrNames.add("ds-task-failed-dependency-action");
        supAttrNames.add("ds-task-log-message");
        supAttrNames.add("ds-task-notify-on-completion");
        supAttrNames.add("ds-task-notify-on-error");
    }
}

