/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.types.LDAPException;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAuthenticationHandler
implements PrivilegedExceptionAction<Object>,
CallbackHandler {
    private ASN1OctetString gssapiBindDN;
    private LDAPReader reader;
    private LDAPWriter writer;
    private AtomicInteger nextMessageID;
    private byte[] iPad;
    private byte[] oPad;
    private char[] gssapiAuthPW;
    private MessageDigest md5Digest;
    private SecureRandom secureRandom;
    private String gssapiAuthID;
    private String gssapiAuthzID;
    private String gssapiQoP;
    private String hostName;
    private String saslMechanism;

    public LDAPAuthenticationHandler(LDAPReader reader, LDAPWriter writer, String hostName, AtomicInteger nextMessageID) {
        this.reader = reader;
        this.writer = writer;
        this.hostName = hostName;
        this.nextMessageID = nextMessageID;
        this.md5Digest = null;
        this.secureRandom = null;
        this.iPad = null;
        this.oPad = null;
    }

    public static String[] getSupportedSASLMechanisms() {
        return new String[]{"ANONYMOUS", "CRAM-MD5", "DIGEST-MD5", "EXTERNAL", "GSSAPI", "PLAIN"};
    }

    public static LinkedHashMap<String, Message> getSASLProperties(String mechanism) {
        String upperName = StaticUtils.toUpperCase(mechanism);
        if (upperName.equals("ANONYMOUS")) {
            return LDAPAuthenticationHandler.getSASLAnonymousProperties();
        }
        if (upperName.equals("CRAM-MD5")) {
            return LDAPAuthenticationHandler.getSASLCRAMMD5Properties();
        }
        if (upperName.equals("DIGEST-MD5")) {
            return LDAPAuthenticationHandler.getSASLDigestMD5Properties();
        }
        if (upperName.equals("EXTERNAL")) {
            return LDAPAuthenticationHandler.getSASLExternalProperties();
        }
        if (upperName.equals("GSSAPI")) {
            return LDAPAuthenticationHandler.getSASLGSSAPIProperties();
        }
        if (upperName.equals("PLAIN")) {
            return LDAPAuthenticationHandler.getSASLPlainProperties();
        }
        return null;
    }

    public String doSimpleBind(int ldapVersion, ASN1OctetString bindDN, ASN1OctetString bindPassword, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        if (bindPassword == null) {
            if (bindDN == null) {
                bindPassword = new ASN1OctetString();
            } else {
                System.out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(bindDN.stringValue()));
                System.out.flush();
                char[] pwChars = PasswordReader.readPassword();
                if (pwChars == null) {
                    bindPassword = new ASN1OctetString();
                } else {
                    bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                    Arrays.fill(pwChars, '\u0000');
                }
            }
        }
        if (bindDN == null) {
            bindDN = new ASN1OctetString();
        }
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, ldapVersion, bindPassword);
        LDAPMessage bindRequestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(bindRequestMessage);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SIMPLE_BIND.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SIMPLE_BIND.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (ASN1Exception ae) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message, ae);
        }
        catch (LDAPException le) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message, le);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message);
                }
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message);
            }
            default: {
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        Message message = ToolMessages.ERR_LDAPAUTH_SIMPLE_BIND_FAILED.get();
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), message, bindResponse.getMatchedDN(), null);
    }

    public String doSASLBind(ASN1OctetString bindDN, ASN1OctetString bindPassword, String mechanism, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        if (bindDN == null) {
            bindDN = new ASN1OctetString();
        }
        if (mechanism == null || mechanism.length() == 0) {
            Message message = ToolMessages.ERR_LDAPAUTH_NO_SASL_MECHANISM.get();
            throw new ClientException(89, message);
        }
        this.saslMechanism = StaticUtils.toUpperCase(mechanism);
        if (this.saslMechanism.equals("ANONYMOUS")) {
            return this.doSASLAnonymous(bindDN, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("CRAM-MD5")) {
            return this.doSASLCRAMMD5(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("DIGEST-MD5")) {
            return this.doSASLDigestMD5(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("EXTERNAL")) {
            return this.doSASLExternal(bindDN, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("GSSAPI")) {
            return this.doSASLGSSAPI(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("PLAIN")) {
            return this.doSASLPlain(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        Message message = ToolMessages.ERR_LDAPAUTH_UNSUPPORTED_SASL_MECHANISM.get(mechanism);
        throw new ClientException(86, message);
    }

    public String doSASLAnonymous(ASN1OctetString bindDN, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        String trace = null;
        if (saslProperties != null && !saslProperties.isEmpty()) {
            for (String name : saslProperties.keySet()) {
                if (name.equalsIgnoreCase("trace")) {
                    List<String> values = saslProperties.get(name);
                    Iterator<String> iterator = values.iterator();
                    if (!iterator.hasNext()) continue;
                    trace = iterator.next();
                    if (!iterator.hasNext()) continue;
                    Message message = ToolMessages.ERR_LDAPAUTH_TRACE_SINGLE_VALUED.get();
                    throw new ClientException(89, message);
                }
                Message message = ToolMessages.ERR_LDAPAUTH_INVALID_SASL_PROPERTY.get(name, "ANONYMOUS");
                throw new ClientException(89, message);
            }
        }
        ASN1OctetString saslCredentials = trace == null ? null : new ASN1OctetString(trace);
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, "ANONYMOUS", saslCredentials);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("ANONYMOUS", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("ANONYMOUS", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (ASN1Exception ae) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message, ae);
        }
        catch (LDAPException le) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message, le);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message);
                }
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message);
            }
            default: {
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        Message message = ToolMessages.ERR_LDAPAUTH_SASL_BIND_FAILED.get("ANONYMOUS");
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), message, bindResponse.getMatchedDN(), null);
    }

    public static LinkedHashMap<String, Message> getSASLAnonymousProperties() {
        LinkedHashMap<String, Message> properties = new LinkedHashMap<String, Message>(1);
        properties.put("trace", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_TRACE.get());
        return properties;
    }

    public String doSASLCRAMMD5(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage2;
        LDAPMessage responseMessage1;
        Message message;
        String authID = null;
        if (saslProperties == null || saslProperties.isEmpty()) {
            Message message2 = ToolMessages.ERR_LDAPAUTH_NO_SASL_PROPERTIES.get("CRAM-MD5");
            throw new ClientException(89, message2);
        }
        for (String name : saslProperties.keySet()) {
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                List<String> values = saslProperties.get(name);
                Iterator<String> iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authID = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message3 = ToolMessages.ERR_LDAPAUTH_AUTHID_SINGLE_VALUED.get();
                throw new ClientException(89, message3);
            }
            Message message4 = ToolMessages.ERR_LDAPAUTH_INVALID_SASL_PROPERTY.get(name, "CRAM-MD5");
            throw new ClientException(89, message4);
        }
        if (authID == null || authID.length() == 0) {
            Message message5 = ToolMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get("CRAM-MD5");
            throw new ClientException(89, message5);
        }
        if (bindPassword == null) {
            System.out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(authID));
            char[] pwChars = PasswordReader.readPassword();
            if (pwChars == null) {
                bindPassword = new ASN1OctetString();
            } else {
                bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                Arrays.fill(pwChars, '\u0000');
            }
        }
        BindRequestProtocolOp bindRequest1 = new BindRequestProtocolOp(bindDN, "CRAM-MD5", null);
        LDAPMessage requestMessage1 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest1);
        try {
            this.writer.writeMessage(requestMessage1);
        }
        catch (IOException ioe) {
            message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_INITIAL_SASL_BIND.get("CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_INITIAL_SASL_BIND.get("CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage1 = this.reader.readMessage();
            if (responseMessage1 == null) {
                message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message6 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message6, ioe);
        }
        catch (ASN1Exception ae) {
            Message message7 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message7, ae);
        }
        catch (LDAPException le) {
            Message message8 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message8, le);
        }
        catch (Exception e) {
            Message message9 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message9, e);
        }
        switch (responseMessage1.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage1.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message10 = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message10);
                }
                Message message11 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message11);
            }
            default: {
                Message message12 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage1.getProtocolOp()));
                throw new ClientException(82, message12);
            }
        }
        BindResponseProtocolOp bindResponse1 = responseMessage1.getBindResponseProtocolOp();
        int resultCode1 = bindResponse1.getResultCode();
        if (resultCode1 != 14) {
            Message errorMessage = bindResponse1.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = Message.EMPTY;
            }
            Message message13 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_INITIAL_BIND_RESPONSE.get("CRAM-MD5", resultCode1, LDAPResultCode.toString(resultCode1), errorMessage);
            throw new LDAPException(resultCode1, errorMessage, message13, bindResponse1.getMatchedDN(), null);
        }
        ASN1OctetString serverChallenge = bindResponse1.getServerSASLCredentials();
        if (serverChallenge == null) {
            Message message14 = ToolMessages.ERR_LDAPAUTH_NO_CRAMMD5_SERVER_CREDENTIALS.get();
            throw new LDAPException(2, message14);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(authID);
        buffer.append(' ');
        buffer.append(this.generateCRAMMD5Digest(bindPassword, serverChallenge));
        BindRequestProtocolOp bindRequest2 = new BindRequestProtocolOp(bindDN, "CRAM-MD5", new ASN1OctetString(buffer.toString()));
        LDAPMessage requestMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest2, requestControls);
        try {
            this.writer.writeMessage(requestMessage2);
        }
        catch (IOException ioe) {
            Message message15 = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SECOND_SASL_BIND.get("CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message15, ioe);
        }
        catch (Exception e) {
            Message message16 = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SECOND_SASL_BIND.get("CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message16, e);
        }
        try {
            responseMessage2 = this.reader.readMessage();
            if (responseMessage2 == null) {
                Message message17 = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message17);
            }
        }
        catch (IOException ioe) {
            Message message18 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message18, ioe);
        }
        catch (ASN1Exception ae) {
            Message message19 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message19, ae);
        }
        catch (LDAPException le) {
            Message message20 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message20, le);
        }
        catch (Exception e) {
            Message message21 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message21, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage2.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage2.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage2.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message22 = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message22);
                }
                Message message23 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message23);
            }
            default: {
                Message message24 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage2.getProtocolOp()));
                throw new ClientException(82, message24);
            }
        }
        BindResponseProtocolOp bindResponse2 = responseMessage2.getBindResponseProtocolOp();
        int resultCode2 = bindResponse2.getResultCode();
        if (resultCode2 == 0) {
            return null;
        }
        Message message25 = ToolMessages.ERR_LDAPAUTH_SASL_BIND_FAILED.get("CRAM-MD5");
        throw new LDAPException(resultCode2, bindResponse2.getErrorMessage(), message25, bindResponse2.getMatchedDN(), null);
    }

    private String generateCRAMMD5Digest(ASN1OctetString password, ASN1OctetString challenge) throws ClientException {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_INITIALIZE_MD5_DIGEST.get(StaticUtils.getExceptionMessage(e));
                throw new ClientException(82, message, e);
            }
        }
        if (this.iPad == null) {
            this.iPad = new byte[64];
            this.oPad = new byte[64];
            Arrays.fill(this.iPad, (byte)54);
            Arrays.fill(this.oPad, (byte)92);
        }
        byte[] p = password.value();
        byte[] c = challenge.value();
        if (p.length > 64) {
            p = this.md5Digest.digest(p);
        }
        byte[] iPadAndData = new byte[64 + c.length];
        System.arraycopy(this.iPad, 0, iPadAndData, 0, 64);
        System.arraycopy(c, 0, iPadAndData, 64, c.length);
        byte[] oPadAndHash = new byte[80];
        System.arraycopy(this.oPad, 0, oPadAndHash, 0, 64);
        for (int i = 0; i < p.length; ++i) {
            int n = i;
            iPadAndData[n] = (byte)(iPadAndData[n] ^ p[i]);
            int n2 = i;
            oPadAndHash[n2] = (byte)(oPadAndHash[n2] ^ p[i]);
        }
        System.arraycopy(this.md5Digest.digest(iPadAndData), 0, oPadAndHash, 64, 16);
        byte[] digestBytes = this.md5Digest.digest(oPadAndHash);
        StringBuilder hexDigest = new StringBuilder(2 * digestBytes.length);
        for (byte b : digestBytes) {
            hexDigest.append(StaticUtils.byteToLowerHex(b));
        }
        return hexDigest.toString();
    }

    public static LinkedHashMap<String, Message> getSASLCRAMMD5Properties() {
        LinkedHashMap<String, Message> properties = new LinkedHashMap<String, Message>(1);
        properties.put("authid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHID.get());
        return properties;
    }

    public String doSASLDigestMD5(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        byte[] clientRspAuth;
        byte[] serverRspAuth;
        LDAPMessage responseMessage2;
        String responseDigest;
        LDAPMessage responseMessage1;
        Message message;
        String authID = null;
        String realm = null;
        String qop = "auth";
        String digestURI = "ldap/" + this.hostName;
        String authzID = null;
        boolean realmSetFromProperty = false;
        if (saslProperties == null || saslProperties.isEmpty()) {
            Message message2 = ToolMessages.ERR_LDAPAUTH_NO_SASL_PROPERTIES.get("DIGEST-MD5");
            throw new ClientException(89, message2);
        }
        for (String name : saslProperties.keySet()) {
            Iterator<String> iterator;
            List<String> values;
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authID = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message3 = ToolMessages.ERR_LDAPAUTH_AUTHID_SINGLE_VALUED.get();
                throw new ClientException(89, message3);
            }
            if (lowerName.equals("realm")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                realm = iterator.next();
                realmSetFromProperty = true;
                if (!iterator.hasNext()) continue;
                Message message4 = ToolMessages.ERR_LDAPAUTH_REALM_SINGLE_VALUED.get();
                throw new ClientException(89, message4);
            }
            if (lowerName.equals("qop")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                qop = StaticUtils.toLowerCase(iterator.next());
                if (iterator.hasNext()) {
                    Message message5 = ToolMessages.ERR_LDAPAUTH_QOP_SINGLE_VALUED.get();
                    throw new ClientException(89, message5);
                }
                if (qop.equals("auth")) continue;
                if (qop.equals("auth-int") || qop.equals("auth-conf")) {
                    Message message6 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_QOP_NOT_SUPPORTED.get(qop);
                    throw new ClientException(89, message6);
                }
                Message message7 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_INVALID_QOP.get(qop);
                throw new ClientException(89, message7);
            }
            if (lowerName.equals("digest-uri")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                digestURI = StaticUtils.toLowerCase(iterator.next());
                if (!iterator.hasNext()) continue;
                Message message8 = ToolMessages.ERR_LDAPAUTH_DIGEST_URI_SINGLE_VALUED.get();
                throw new ClientException(89, message8);
            }
            if (lowerName.equals("authzid")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authzID = StaticUtils.toLowerCase(iterator.next());
                if (!iterator.hasNext()) continue;
                Message message9 = ToolMessages.ERR_LDAPAUTH_AUTHZID_SINGLE_VALUED.get();
                throw new ClientException(89, message9);
            }
            Message message10 = ToolMessages.ERR_LDAPAUTH_INVALID_SASL_PROPERTY.get(name, "DIGEST-MD5");
            throw new ClientException(89, message10);
        }
        if (authID == null || authID.length() == 0) {
            Message message11 = ToolMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get("DIGEST-MD5");
            throw new ClientException(89, message11);
        }
        if (bindPassword == null) {
            System.out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(authID));
            char[] pwChars = PasswordReader.readPassword();
            if (pwChars == null) {
                bindPassword = new ASN1OctetString();
            } else {
                bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                Arrays.fill(pwChars, '\u0000');
            }
        }
        BindRequestProtocolOp bindRequest1 = new BindRequestProtocolOp(bindDN, "DIGEST-MD5", null);
        LDAPMessage requestMessage1 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest1);
        try {
            this.writer.writeMessage(requestMessage1);
        }
        catch (IOException ioe) {
            message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_INITIAL_SASL_BIND.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_INITIAL_SASL_BIND.get("DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage1 = this.reader.readMessage();
            if (responseMessage1 == null) {
                message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message12 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message12, ioe);
        }
        catch (ASN1Exception ae) {
            Message message13 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message13, ae);
        }
        catch (LDAPException le) {
            Message message14 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message14, le);
        }
        catch (Exception e) {
            Message message15 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_INITIAL_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message15, e);
        }
        switch (responseMessage1.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage1.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message16 = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message16);
                }
                Message message17 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message17);
            }
            default: {
                Message message18 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage1.getProtocolOp()));
                throw new ClientException(82, message18);
            }
        }
        BindResponseProtocolOp bindResponse1 = responseMessage1.getBindResponseProtocolOp();
        int resultCode1 = bindResponse1.getResultCode();
        if (resultCode1 != 14) {
            Message errorMessage = bindResponse1.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = Message.EMPTY;
            }
            Message message19 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_INITIAL_BIND_RESPONSE.get("DIGEST-MD5", resultCode1, LDAPResultCode.toString(resultCode1), errorMessage);
            throw new LDAPException(resultCode1, errorMessage, message19, bindResponse1.getMatchedDN(), null);
        }
        ASN1OctetString serverCredentials = bindResponse1.getServerSASLCredentials();
        if (serverCredentials == null) {
            Message message20 = ToolMessages.ERR_LDAPAUTH_NO_DIGESTMD5_SERVER_CREDENTIALS.get();
            throw new LDAPException(2, message20);
        }
        String credString = serverCredentials.stringValue();
        String lowerCreds = StaticUtils.toLowerCase(credString);
        String nonce = null;
        boolean useUTF8 = false;
        int pos = 0;
        int length = credString.length();
        while (pos < length) {
            int equalPos = credString.indexOf(61, pos + 1);
            if (equalPos < 0) {
                Message message21 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_INVALID_TOKEN_IN_CREDENTIALS.get(credString, pos);
                throw new LDAPException(2, message21);
            }
            String tokenName = lowerCreds.substring(pos, equalPos);
            StringBuilder valueBuffer = new StringBuilder();
            pos = this.readToken(credString, equalPos + 1, length, valueBuffer);
            String tokenValue = valueBuffer.toString();
            if (tokenName.equals("charset")) {
                if (!tokenValue.equalsIgnoreCase("utf-8")) {
                    Message message22 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_INVALID_CHARSET.get(tokenValue);
                    throw new LDAPException(2, message22);
                }
                useUTF8 = true;
                continue;
            }
            if (tokenName.equals("realm")) {
                if (realmSetFromProperty) continue;
                if (realm == null) {
                    realm = tokenValue;
                    continue;
                }
                realm = null;
                realmSetFromProperty = true;
                continue;
            }
            if (tokenName.equals("nonce")) {
                nonce = tokenValue;
                continue;
            }
            if (!tokenName.equals("qop")) continue;
            StringTokenizer tokenizer = new StringTokenizer(tokenValue, ",");
            LinkedList<String> qopModes = new LinkedList<String>();
            while (tokenizer.hasMoreTokens()) {
                qopModes.add(StaticUtils.toLowerCase(tokenizer.nextToken().trim()));
            }
            if (qopModes.contains(qop)) continue;
            Message message23 = ToolMessages.ERR_LDAPAUTH_REQUESTED_QOP_NOT_SUPPORTED_BY_SERVER.get(qop, tokenValue);
            throw new ClientException(89, message23);
        }
        if (nonce == null) {
            Message message24 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_NO_NONCE.get();
            throw new LDAPException(2, message24);
        }
        String cnonce = this.generateCNonce();
        String nonceCount = "00000001";
        String charset = useUTF8 ? "UTF-8" : "ISO-8859-1";
        try {
            responseDigest = this.generateDigestMD5Response(authID, authzID, bindPassword.value(), realm, nonce, cnonce, nonceCount, digestURI, qop, charset);
        }
        catch (ClientException ce) {
            throw ce;
        }
        catch (Exception e) {
            Message message25 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_CANNOT_CREATE_RESPONSE_DIGEST.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message25, e);
        }
        StringBuilder credBuffer = new StringBuilder();
        credBuffer.append("username=\"");
        credBuffer.append(authID);
        credBuffer.append("\"");
        if (realm != null) {
            credBuffer.append(",realm=\"");
            credBuffer.append(realm);
            credBuffer.append("\"");
        }
        credBuffer.append(",nonce=\"");
        credBuffer.append(nonce);
        credBuffer.append("\",cnonce=\"");
        credBuffer.append(cnonce);
        credBuffer.append("\",nc=");
        credBuffer.append(nonceCount);
        credBuffer.append(",qop=");
        credBuffer.append(qop);
        credBuffer.append(",digest-uri=\"");
        credBuffer.append(digestURI);
        credBuffer.append("\",response=");
        credBuffer.append(responseDigest);
        if (useUTF8) {
            credBuffer.append(",charset=utf-8");
        }
        if (authzID != null) {
            credBuffer.append(",authzid=\"");
            credBuffer.append(authzID);
            credBuffer.append("\"");
        }
        BindRequestProtocolOp bindRequest2 = new BindRequestProtocolOp(bindDN, "DIGEST-MD5", new ASN1OctetString(credBuffer.toString()));
        LDAPMessage requestMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest2, requestControls);
        try {
            this.writer.writeMessage(requestMessage2);
        }
        catch (IOException ioe) {
            Message message26 = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SECOND_SASL_BIND.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message26, ioe);
        }
        catch (Exception e) {
            Message message27 = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SECOND_SASL_BIND.get("DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message27, e);
        }
        try {
            responseMessage2 = this.reader.readMessage();
            if (responseMessage2 == null) {
                Message message28 = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message28);
            }
        }
        catch (IOException ioe) {
            Message message29 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message29, ioe);
        }
        catch (ASN1Exception ae) {
            Message message30 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message30, ae);
        }
        catch (LDAPException le) {
            Message message31 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message31, le);
        }
        catch (Exception e) {
            Message message32 = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_SECOND_BIND_RESPONSE.get("DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message32, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage2.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage2.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage2.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message33 = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message33);
                }
                Message message34 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message34);
            }
            default: {
                Message message35 = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage2.getProtocolOp()));
                throw new ClientException(82, message35);
            }
        }
        BindResponseProtocolOp bindResponse2 = responseMessage2.getBindResponseProtocolOp();
        int resultCode2 = bindResponse2.getResultCode();
        if (resultCode2 != 0) {
            Message message36 = ToolMessages.ERR_LDAPAUTH_SASL_BIND_FAILED.get("DIGEST-MD5");
            throw new LDAPException(resultCode2, bindResponse2.getErrorMessage(), message36, bindResponse2.getMatchedDN(), null);
        }
        ASN1OctetString rspAuthCreds = bindResponse2.getServerSASLCredentials();
        if (rspAuthCreds == null) {
            Message message37 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_NO_RSPAUTH_CREDS.get();
            throw new LDAPException(2, message37);
        }
        String credStr = StaticUtils.toLowerCase(rspAuthCreds.stringValue());
        if (!credStr.startsWith("rspauth=")) {
            Message message38 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_NO_RSPAUTH_CREDS.get();
            throw new LDAPException(2, message38);
        }
        try {
            serverRspAuth = StaticUtils.hexStringToByteArray(credStr.substring(8));
        }
        catch (Exception e) {
            Message message39 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_COULD_NOT_DECODE_RSPAUTH.get(StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, message39);
        }
        try {
            clientRspAuth = this.generateDigestMD5RspAuth(authID, authzID, bindPassword.value(), realm, nonce, cnonce, nonceCount, digestURI, qop, charset);
        }
        catch (Exception e) {
            Message message40 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_COULD_NOT_CALCULATE_RSPAUTH.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message40);
        }
        if (!Arrays.equals(serverRspAuth, clientRspAuth)) {
            Message message41 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_RSPAUTH_MISMATCH.get();
            throw new ClientException(82, message41);
        }
        return null;
    }

    private int readToken(String credentials, int startPos, int length, StringBuilder token) throws LDAPException {
        char c;
        if (startPos >= length) {
            return startPos;
        }
        boolean isEscaped = false;
        boolean isQuoted = false;
        int pos = startPos;
        if ((c = credentials.charAt(pos++)) == ',') {
            return pos;
        }
        if (c == '\"') {
            isQuoted = true;
        } else if (c == '\\') {
            isEscaped = true;
        } else {
            token.append(c);
        }
        while (pos < length) {
            c = credentials.charAt(pos++);
            if (isEscaped) {
                token.append(c);
                isEscaped = false;
                continue;
            }
            if (c == ',') {
                if (!isQuoted) break;
                token.append(c);
                continue;
            }
            if (c == '\"') {
                if (isQuoted) {
                    char c2;
                    if (pos >= length || (c2 = credentials.charAt(pos++)) == ',') break;
                    Message message = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_INVALID_CLOSING_QUOTE_POS.get(pos - 2);
                    throw new LDAPException(49, message);
                }
                token.append(c);
                continue;
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            token.append(c);
        }
        return pos;
    }

    private String generateCNonce() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        byte[] cnonceBytes = new byte[16];
        this.secureRandom.nextBytes(cnonceBytes);
        return Base64.encode(cnonceBytes);
    }

    private String generateDigestMD5Response(String authID, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws ClientException, UnsupportedEncodingException {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_INITIALIZE_MD5_DIGEST.get(StaticUtils.getExceptionMessage(e));
                throw new ClientException(82, message, e);
            }
        }
        StringBuilder a1String1 = new StringBuilder();
        a1String1.append(authID);
        a1String1.append(':');
        a1String1.append(realm == null ? "" : realm);
        a1String1.append(':');
        byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
        byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
        System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
        System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
        byte[] urpHash = this.md5Digest.digest(a1Bytes1);
        StringBuilder a1String2 = new StringBuilder();
        a1String2.append(':');
        a1String2.append(nonce);
        a1String2.append(':');
        a1String2.append(cnonce);
        if (authzID != null) {
            a1String2.append(':');
            a1String2.append(authzID);
        }
        byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
        byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
        System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
        System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
        byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
        byte[] a2Bytes = ("AUTHENTICATE:" + digestURI).getBytes(charset);
        byte[] a2Hash = this.md5Digest.digest(a2Bytes);
        String a1HashHex = this.getHexString(a1Hash);
        String a2HashHex = this.getHexString(a2Hash);
        StringBuilder kdStr = new StringBuilder();
        kdStr.append(a1HashHex);
        kdStr.append(':');
        kdStr.append(nonce);
        kdStr.append(':');
        kdStr.append(nonceCount);
        kdStr.append(':');
        kdStr.append(cnonce);
        kdStr.append(':');
        kdStr.append(qop);
        kdStr.append(':');
        kdStr.append(a2HashHex);
        return this.getHexString(this.md5Digest.digest(kdStr.toString().getBytes(charset)));
    }

    public byte[] generateDigestMD5RspAuth(String authID, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws UnsupportedEncodingException {
        StringBuilder a1String1 = new StringBuilder();
        a1String1.append(authID);
        a1String1.append(':');
        a1String1.append(realm);
        a1String1.append(':');
        byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
        byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
        System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
        System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
        byte[] urpHash = this.md5Digest.digest(a1Bytes1);
        StringBuilder a1String2 = new StringBuilder();
        a1String2.append(':');
        a1String2.append(nonce);
        a1String2.append(':');
        a1String2.append(cnonce);
        if (authzID != null) {
            a1String2.append(':');
            a1String2.append(authzID);
        }
        byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
        byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
        System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
        System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
        byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
        String a2String = ":" + digestURI;
        if (qop.equals("auth-int") || qop.equals("auth-conf")) {
            a2String = a2String + ":00000000000000000000000000000000";
        }
        byte[] a2Bytes = a2String.getBytes(charset);
        byte[] a2Hash = this.md5Digest.digest(a2Bytes);
        String a1HashHex = this.getHexString(a1Hash);
        String a2HashHex = this.getHexString(a2Hash);
        StringBuilder kdStr = new StringBuilder();
        kdStr.append(a1HashHex);
        kdStr.append(':');
        kdStr.append(nonce);
        kdStr.append(':');
        kdStr.append(nonceCount);
        kdStr.append(':');
        kdStr.append(cnonce);
        kdStr.append(':');
        kdStr.append(qop);
        kdStr.append(':');
        kdStr.append(a2HashHex);
        return this.md5Digest.digest(kdStr.toString().getBytes(charset));
    }

    private String getHexString(byte[] byteArray) {
        StringBuilder buffer = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            buffer.append(StaticUtils.byteToLowerHex(b));
        }
        return buffer.toString();
    }

    public static LinkedHashMap<String, Message> getSASLDigestMD5Properties() {
        LinkedHashMap<String, Message> properties = new LinkedHashMap<String, Message>(5);
        properties.put("authid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHID.get());
        properties.put("realm", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_REALM.get());
        properties.put("qop", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_QOP.get());
        properties.put("digest-uri", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_DIGEST_URI.get());
        properties.put("authzid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHZID.get());
        return properties;
    }

    public String doSASLExternal(ASN1OctetString bindDN, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        if (saslProperties != null && !saslProperties.isEmpty()) {
            Message message = ToolMessages.ERR_LDAPAUTH_NO_ALLOWED_SASL_PROPERTIES.get("EXTERNAL");
            throw new ClientException(89, message);
        }
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, "EXTERNAL", null);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("EXTERNAL", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("EXTERNAL", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (ASN1Exception ae) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message, ae);
        }
        catch (LDAPException le) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message, le);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message);
                }
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message);
            }
            default: {
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        Message message = ToolMessages.ERR_LDAPAUTH_SASL_BIND_FAILED.get("EXTERNAL");
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), message, bindResponse.getMatchedDN(), null);
    }

    public static LinkedHashMap<String, Message> getSASLExternalProperties() {
        return new LinkedHashMap<String, Message>(0);
    }

    public String doSASLGSSAPI(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        Message message;
        LoginContext loginContext;
        String configFileName;
        Message message2;
        String kdc = null;
        String realm = null;
        this.gssapiBindDN = bindDN;
        this.gssapiAuthID = null;
        this.gssapiAuthzID = null;
        this.gssapiQoP = "auth";
        this.gssapiAuthPW = (char[])(bindPassword == null ? null : bindPassword.stringValue().toCharArray());
        if (saslProperties == null || saslProperties.isEmpty()) {
            Message message3 = ToolMessages.ERR_LDAPAUTH_NO_SASL_PROPERTIES.get("GSSAPI");
            throw new ClientException(89, message3);
        }
        for (String name : saslProperties.keySet()) {
            Iterator<String> iterator;
            List<String> values;
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiAuthID = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message4 = ToolMessages.ERR_LDAPAUTH_AUTHID_SINGLE_VALUED.get();
                throw new ClientException(89, message4);
            }
            if (lowerName.equals("authzid")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiAuthzID = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message5 = ToolMessages.ERR_LDAPAUTH_AUTHZID_SINGLE_VALUED.get();
                throw new ClientException(89, message5);
            }
            if (lowerName.equals("kdc")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                kdc = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message6 = ToolMessages.ERR_LDAPAUTH_KDC_SINGLE_VALUED.get();
                throw new ClientException(89, message6);
            }
            if (lowerName.equals("qop")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiQoP = StaticUtils.toLowerCase(iterator.next());
                if (iterator.hasNext()) {
                    Message message7 = ToolMessages.ERR_LDAPAUTH_QOP_SINGLE_VALUED.get();
                    throw new ClientException(89, message7);
                }
                if (this.gssapiQoP.equals("auth")) continue;
                if (this.gssapiQoP.equals("auth-int") || this.gssapiQoP.equals("auth-conf")) {
                    Message message8 = ToolMessages.ERR_LDAPAUTH_DIGESTMD5_QOP_NOT_SUPPORTED.get(this.gssapiQoP);
                    throw new ClientException(89, message8);
                }
                Message message9 = ToolMessages.ERR_LDAPAUTH_GSSAPI_INVALID_QOP.get(this.gssapiQoP);
                throw new ClientException(89, message9);
            }
            if (lowerName.equals("realm")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                realm = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message10 = ToolMessages.ERR_LDAPAUTH_REALM_SINGLE_VALUED.get();
                throw new ClientException(89, message10);
            }
            message2 = ToolMessages.ERR_LDAPAUTH_INVALID_SASL_PROPERTY.get(name, "GSSAPI");
            throw new ClientException(89, message2);
        }
        if (this.gssapiAuthID == null || this.gssapiAuthID.length() == 0) {
            Message message11 = ToolMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get("GSSAPI");
            throw new ClientException(89, message11);
        }
        if (this.gssapiAuthzID == null) {
            this.gssapiAuthzID = this.gssapiAuthID;
        }
        if (realm != null) {
            System.setProperty("java.security.krb5.realm", realm);
        }
        if (kdc != null) {
            System.setProperty("java.security.krb5.kdc", kdc);
        }
        try {
            File tempFile = File.createTempFile("login", "conf");
            configFileName = tempFile.getAbsolutePath();
            tempFile.deleteOnExit();
            BufferedWriter w = new BufferedWriter(new FileWriter(tempFile, false));
            w.write(this.getClass().getName() + " {");
            w.newLine();
            w.write("  com.sun.security.auth.module.Krb5LoginModule required client=TRUE useTicketCache=TRUE;");
            w.newLine();
            w.write("};");
            w.newLine();
            w.flush();
            w.close();
        }
        catch (Exception e) {
            message2 = ToolMessages.ERR_LDAPAUTH_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message2, e);
        }
        System.setProperty("java.security.auth.login.config", configFileName);
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
        try {
            loginContext = new LoginContext(this.getClass().getName(), this);
            loginContext.login();
        }
        catch (Exception e) {
            message = ToolMessages.ERR_LDAPAUTH_GSSAPI_LOCAL_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        try {
            Subject.doAs(loginContext.getSubject(), this);
        }
        catch (Exception e) {
            if (e instanceof ClientException) {
                throw (ClientException)e;
            }
            if (e instanceof LDAPException) {
                throw (LDAPException)e;
            }
            message = ToolMessages.ERR_LDAPAUTH_GSSAPI_REMOTE_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        return null;
    }

    public static LinkedHashMap<String, Message> getSASLGSSAPIProperties() {
        LinkedHashMap<String, Message> properties = new LinkedHashMap<String, Message>(4);
        properties.put("authid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHID.get());
        properties.put("authzid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHZID.get());
        properties.put("kdc", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_KDC.get());
        properties.put("realm", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_REALM.get());
        return properties;
    }

    public String doSASLPlain(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        String authID = null;
        String authzID = null;
        if (saslProperties == null || saslProperties.isEmpty()) {
            Message message = ToolMessages.ERR_LDAPAUTH_NO_SASL_PROPERTIES.get("PLAIN");
            throw new ClientException(89, message);
        }
        for (String name : saslProperties.keySet()) {
            Iterator<String> iterator;
            List<String> values;
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authID = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message = ToolMessages.ERR_LDAPAUTH_AUTHID_SINGLE_VALUED.get();
                throw new ClientException(89, message);
            }
            if (lowerName.equals("authzid")) {
                values = saslProperties.get(name);
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authzID = iterator.next();
                if (!iterator.hasNext()) continue;
                Message message = ToolMessages.ERR_LDAPAUTH_AUTHZID_SINGLE_VALUED.get();
                throw new ClientException(89, message);
            }
            Message message = ToolMessages.ERR_LDAPAUTH_INVALID_SASL_PROPERTY.get(name, "PLAIN");
            throw new ClientException(89, message);
        }
        if (authID == null || authID.length() == 0) {
            Message message = ToolMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get("PLAIN");
            throw new ClientException(89, message);
        }
        if (bindPassword == null) {
            System.out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(authID));
            char[] pwChars = PasswordReader.readPassword();
            if (pwChars == null) {
                bindPassword = new ASN1OctetString();
            } else {
                bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                Arrays.fill(pwChars, '\u0000');
            }
        }
        StringBuilder credBuffer = new StringBuilder();
        if (authzID != null) {
            credBuffer.append(authzID);
        }
        credBuffer.append('\u0000');
        credBuffer.append(authID);
        credBuffer.append('\u0000');
        credBuffer.append(bindPassword.stringValue());
        ASN1OctetString saslCredentials = new ASN1OctetString(credBuffer.toString());
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, "PLAIN", saslCredentials);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("PLAIN", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("PLAIN", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (ASN1Exception ae) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message, ae);
        }
        catch (LDAPException le) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message, le);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), message);
                }
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                throw new ClientException(82, message);
            }
            default: {
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        Message message = ToolMessages.ERR_LDAPAUTH_SASL_BIND_FAILED.get("PLAIN");
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), message, bindResponse.getMatchedDN(), null);
    }

    public static LinkedHashMap<String, Message> getSASLPlainProperties() {
        LinkedHashMap<String, Message> properties = new LinkedHashMap<String, Message>(2);
        properties.put("authid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHID.get());
        properties.put("authzid", ToolMessages.INFO_LDAPAUTH_PROPERTY_DESCRIPTION_AUTHZID.get());
        return properties;
    }

    @Override
    public Object run() throws ClientException, LDAPException {
        block44: {
            if (this.saslMechanism == null) {
                Message message = ToolMessages.ERR_LDAPAUTH_NONSASL_RUN_INVOCATION.get(StaticUtils.getBacktrace());
                throw new ClientException(82, message);
            }
            if (this.saslMechanism.equals("GSSAPI")) {
                BindResponseProtocolOp bindResponse;
                int resultCode;
                LDAPMessage responseMessage;
                ASN1OctetString saslCredentials;
                SaslClient saslClient;
                HashMap<String, String> saslProperties = new HashMap<String, String>();
                saslProperties.put("javax.security.sasl.qop", this.gssapiQoP);
                saslProperties.put("javax.security.sasl.server.authentication", "true");
                try {
                    saslClient = Sasl.createSaslClient(new String[]{"GSSAPI"}, this.gssapiAuthzID, "ldap", this.hostName, saslProperties, this);
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDAPAUTH_GSSAPI_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e));
                    throw new ClientException(82, message, e);
                }
                if (saslClient.hasInitialResponse()) {
                    try {
                        byte[] credBytes = saslClient.evaluateChallenge(new byte[0]);
                        saslCredentials = new ASN1OctetString(credBytes);
                    }
                    catch (Exception e) {
                        Message message = ToolMessages.ERR_LDAPAUTH_GSSAPI_CANNOT_CREATE_INITIAL_CHALLENGE.get(StaticUtils.getExceptionMessage(e));
                        throw new ClientException(82, message, e);
                    }
                } else {
                    saslCredentials = null;
                }
                BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(this.gssapiBindDN, "GSSAPI", saslCredentials);
                LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest);
                try {
                    this.writer.writeMessage(requestMessage);
                }
                catch (IOException ioe) {
                    Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("GSSAPI", StaticUtils.getExceptionMessage(ioe));
                    throw new ClientException(81, message, ioe);
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("GSSAPI", StaticUtils.getExceptionMessage(e));
                    throw new ClientException(83, message, e);
                }
                try {
                    responseMessage = this.reader.readMessage();
                    if (responseMessage == null) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                        throw new ClientException(81, message);
                    }
                }
                catch (IOException ioe) {
                    Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
                    throw new ClientException(81, message, ioe);
                }
                catch (ASN1Exception ae) {
                    Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
                    throw new ClientException(84, message, ae);
                }
                catch (LDAPException le) {
                    Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(le));
                    throw new ClientException(84, message, le);
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(e));
                    throw new ClientException(82, message, e);
                }
                switch (responseMessage.getProtocolOpType()) {
                    case 97: {
                        break;
                    }
                    case 120: {
                        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                        String responseOID = extendedResponse.getOID();
                        if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                            Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                            throw new LDAPException(extendedResponse.getResultCode(), message);
                        }
                        Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                        throw new ClientException(82, message);
                    }
                    default: {
                        Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
                        throw new ClientException(82, message);
                    }
                }
                while (true) {
                    byte[] credBytes;
                    ASN1OctetString serverSASLCredentials;
                    if ((resultCode = (bindResponse = responseMessage.getBindResponseProtocolOp()).getResultCode()) == 0) {
                        serverSASLCredentials = bindResponse.getServerSASLCredentials();
                        if (serverSASLCredentials != null) {
                            try {
                                saslClient.evaluateChallenge(serverSASLCredentials.value());
                            }
                            catch (Exception e) {
                                Message message = ToolMessages.ERR_LDAPAUTH_GSSAPI_CANNOT_VALIDATE_SERVER_CREDS.get(StaticUtils.getExceptionMessage(e));
                                throw new ClientException(82, message, e);
                            }
                        }
                        if (!saslClient.isComplete()) {
                            Message message = ToolMessages.ERR_LDAPAUTH_GSSAPI_UNEXPECTED_SUCCESS_RESPONSE.get();
                            throw new ClientException(82, message);
                        }
                        break block44;
                    }
                    if (resultCode != 14) break;
                    serverSASLCredentials = bindResponse.getServerSASLCredentials();
                    try {
                        credBytes = serverSASLCredentials == null ? saslClient.evaluateChallenge(new byte[0]) : saslClient.evaluateChallenge(serverSASLCredentials.value());
                    }
                    catch (Exception e) {
                        Message message = ToolMessages.ERR_LDAPAUTH_GSSAPI_CANNOT_VALIDATE_SERVER_CREDS.get(StaticUtils.getExceptionMessage(e));
                        throw new ClientException(82, message, e);
                    }
                    bindRequest = new BindRequestProtocolOp(this.gssapiBindDN, "GSSAPI", new ASN1OctetString(credBytes));
                    requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest);
                    try {
                        this.writer.writeMessage(requestMessage);
                    }
                    catch (IOException ioe) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("GSSAPI", StaticUtils.getExceptionMessage(ioe));
                        throw new ClientException(81, message, ioe);
                    }
                    catch (Exception e) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_SASL_BIND.get("GSSAPI", StaticUtils.getExceptionMessage(e));
                        throw new ClientException(83, message, e);
                    }
                    try {
                        responseMessage = this.reader.readMessage();
                        if (responseMessage == null) {
                            Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                            throw new ClientException(81, message);
                        }
                    }
                    catch (IOException ioe) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
                        throw new ClientException(81, message, ioe);
                    }
                    catch (ASN1Exception ae) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
                        throw new ClientException(84, message, ae);
                    }
                    catch (LDAPException le) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(le));
                        throw new ClientException(84, message, le);
                    }
                    catch (Exception e) {
                        Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_BIND_RESPONSE.get(StaticUtils.getExceptionMessage(e));
                        throw new ClientException(82, message, e);
                    }
                    switch (responseMessage.getProtocolOpType()) {
                        case 97: {
                            break;
                        }
                        case 120: {
                            ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                            String responseOID = extendedResponse.getOID();
                            if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                                Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                                throw new LDAPException(extendedResponse.getResultCode(), message);
                            }
                            Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_EXTENDED_RESPONSE.get(String.valueOf(extendedResponse));
                            throw new ClientException(82, message);
                        }
                        default: {
                            Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
                            throw new ClientException(82, message);
                        }
                    }
                }
                Message message = ToolMessages.ERR_LDAPAUTH_GSSAPI_BIND_FAILED.get();
                throw new LDAPException(resultCode, bindResponse.getErrorMessage(), message, bindResponse.getMatchedDN(), null);
            }
            Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RUN_INVOCATION.get(this.saslMechanism, StaticUtils.getBacktrace());
            throw new ClientException(82, message);
        }
        return null;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (this.saslMechanism == null) {
            Message message = ToolMessages.ERR_LDAPAUTH_NONSASL_CALLBACK_INVOCATION.get(StaticUtils.getBacktrace());
            throw new UnsupportedCallbackException(callbacks[0], message.toString());
        }
        if (this.saslMechanism.equals("GSSAPI")) {
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.gssapiAuthID);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    if (this.gssapiAuthPW == null) {
                        System.out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(this.gssapiAuthID));
                        this.gssapiAuthPW = PasswordReader.readPassword();
                    }
                    ((PasswordCallback)cb).setPassword(this.gssapiAuthPW);
                    continue;
                }
                Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_GSSAPI_CALLBACK.get(String.valueOf(cb));
                throw new UnsupportedCallbackException(cb, message.toString());
            }
        } else {
            Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_CALLBACK_INVOCATION.get(this.saslMechanism, StaticUtils.getBacktrace());
            throw new UnsupportedCallbackException(callbacks[0], message.toString());
        }
    }

    public ASN1OctetString requestAuthorizationIdentity() throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.4203.1.11.3");
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), extendedRequest);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_WHOAMI_REQUEST.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_SEND_WHOAMI_REQUEST.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_LDAPAUTH_CONNECTION_CLOSED_WITHOUT_BIND_RESPONSE.get();
                throw new ClientException(81, message);
            }
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_WHOAMI_RESPONSE.get(StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, message, ioe);
        }
        catch (ASN1Exception ae) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_WHOAMI_RESPONSE.get(StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, message, ae);
        }
        catch (LDAPException le) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_WHOAMI_RESPONSE.get(StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, message, le);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPAUTH_CANNOT_READ_WHOAMI_RESPONSE.get(StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, message, e);
        }
        if (responseMessage.getProtocolOpType() != 120) {
            Message message = ToolMessages.ERR_LDAPAUTH_UNEXPECTED_RESPONSE.get(String.valueOf(responseMessage.getProtocolOp()));
            throw new ClientException(82, message);
        }
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        String responseOID = extendedResponse.getOID();
        if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
            Message message = ToolMessages.ERR_LDAPAUTH_SERVER_DISCONNECT.get(extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
            throw new LDAPException(extendedResponse.getResultCode(), message);
        }
        int resultCode = extendedResponse.getResultCode();
        if (resultCode != 0) {
            Message message = ToolMessages.ERR_LDAPAUTH_WHOAMI_FAILED.get();
            throw new LDAPException(resultCode, extendedResponse.getErrorMessage(), message, extendedResponse.getMatchedDN(), null);
        }
        ASN1OctetString authzID = extendedResponse.getValue();
        if (authzID == null || authzID.value() == null || authzID.value().length == 0) {
            return null;
        }
        String valueString = authzID.stringValue();
        if (valueString == null || valueString.length() == 0 || valueString.equalsIgnoreCase("dn:")) {
            return null;
        }
        return authzID;
    }
}

