/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class WordEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "wordMatch";
    }

    public String getOID() {
        return "2.5.13.32";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        char c;
        String valueStr2;
        String valueStr1 = value1.stringValue();
        int pos = valueStr1.indexOf(valueStr2 = value2.stringValue());
        if (pos < 0) {
            return false;
        }
        if (pos > 0) {
            c = valueStr1.charAt(pos - 1);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '=': 
                case '_': {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (valueStr1.length() > pos + valueStr2.length()) {
            c = valueStr1.charAt(pos + valueStr2.length());
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '=': 
                case '_': {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        return 1;
    }
}

