/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class IntegerOrderingMatchingRule
extends OrderingMatchingRule {
    private static final long serialVersionUID = 6654300545706161754L;

    public void initializeMatchingRule(OrderingMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "integerOrderingMatch";
    }

    public String getOID() {
        return "2.5.13.15";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        byte[] valueBytes = value.value();
        int length = valueBytes.length;
        StringBuilder buffer = new StringBuilder(length);
        boolean logged = false;
        block41: for (int i = 0; i < length; ++i) {
            switch (valueBytes[i]) {
                case 48: {
                    Message message;
                    switch (buffer.length()) {
                        case 0: {
                            if (i == length - 1) {
                                buffer.append("0");
                                continue block41;
                            }
                            message = SchemaMessages.WARN_ATTR_SYNTAX_INTEGER_INITIAL_ZERO.get(value.stringValue());
                            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                                case REJECT: {
                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                }
                                case WARN: {
                                    if (logged) break;
                                    logged = true;
                                    ErrorLogger.logError(message);
                                }
                            }
                            continue block41;
                        }
                        case 1: {
                            if (buffer.charAt(0) == '-') {
                                message = SchemaMessages.WARN_ATTR_SYNTAX_INTEGER_INITIAL_ZERO.get(value.stringValue());
                                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                                    case REJECT: {
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                    }
                                    case WARN: {
                                        if (logged) break;
                                        logged = true;
                                        ErrorLogger.logError(message);
                                    }
                                }
                                continue block41;
                            }
                            buffer.append("0");
                            continue block41;
                        }
                    }
                    buffer.append("0");
                    continue block41;
                }
                case 49: {
                    buffer.append('1');
                    continue block41;
                }
                case 50: {
                    buffer.append('2');
                    continue block41;
                }
                case 51: {
                    buffer.append('3');
                    continue block41;
                }
                case 52: {
                    buffer.append('4');
                    continue block41;
                }
                case 53: {
                    buffer.append('5');
                    continue block41;
                }
                case 54: {
                    buffer.append('6');
                    continue block41;
                }
                case 55: {
                    buffer.append('7');
                    continue block41;
                }
                case 56: {
                    buffer.append('8');
                    continue block41;
                }
                case 57: {
                    buffer.append('9');
                    continue block41;
                }
                case 45: {
                    if (buffer.length() == 0) {
                        buffer.append("-");
                        continue block41;
                    }
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_INTEGER_MISPLACED_DASH.get(value.stringValue());
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        case WARN: {
                            if (logged) break;
                            logged = true;
                            ErrorLogger.logError(message);
                        }
                    }
                    continue block41;
                }
                default: {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER.get(value.stringValue(), Character.valueOf((char)valueBytes[i]), i);
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        case WARN: {
                            if (logged) continue block41;
                            logged = true;
                            ErrorLogger.logError(message);
                        }
                    }
                }
            }
        }
        if (buffer.length() == 0) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_INTEGER_EMPTY_VALUE.get(value.stringValue());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    if (!logged) {
                        logged = true;
                        ErrorLogger.logError(message);
                    }
                    buffer.append("0");
                    break;
                }
                default: {
                    buffer.append("0");
                    break;
                }
            }
        } else if (buffer.length() == 1 && buffer.charAt(0) == '-') {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_INTEGER_DASH_NEEDS_VALUE.get(value.stringValue());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    if (!logged) {
                        logged = true;
                        ErrorLogger.logError(message);
                    }
                    buffer.setCharAt(0, '0');
                    break;
                }
                default: {
                    buffer.setCharAt(0, '0');
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    public int compareValues(ByteString value1, ByteString value2) {
        return this.compare(value1.value(), value2.value());
    }

    public int compare(byte[] b1, byte[] b2) {
        int b1Length = b1.length;
        int b2Length = b2.length;
        if (b1Length == 0) {
            if (b2Length == 0) {
                return 0;
            }
            if (b2[0] == 45) {
                return 1;
            }
            return -1;
        }
        if (b2Length == 0) {
            if (b1[0] == 45) {
                return -1;
            }
            return 1;
        }
        if (b1[0] == 45) {
            if (b2[0] == 45) {
                if (b1Length > b2Length) {
                    return -1;
                }
                if (b2Length > b1Length) {
                    return 1;
                }
                for (int i = 1; i < b1Length; ++i) {
                    if (b1[i] > b2[i]) {
                        return -1;
                    }
                    if (b1[i] >= b2[i]) continue;
                    return 1;
                }
                return 0;
            }
            return -1;
        }
        if (b2[0] == 45) {
            return 1;
        }
        if (b1Length > b2Length) {
            return 1;
        }
        if (b2Length > b1Length) {
            return -1;
        }
        for (int i = 0; i < b1Length; ++i) {
            if (b1[i] > b2[i]) {
                return 1;
            }
            if (b1[i] >= b2[i]) continue;
            return -1;
        }
        return 0;
    }
}

