/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitStringSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.16");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.16", "BitString"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "BitString";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.6";
    }

    @Override
    public String getDescription() {
        return "Bit String";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        String valueString = value.stringValue().toUpperCase();
        int length = valueString.length();
        if (length < 3) {
            invalidReason.append(SchemaMessages.WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT.get(value.stringValue()));
            return false;
        }
        if (valueString.charAt(0) != '\'' || valueString.charAt(length - 2) != '\'' || valueString.charAt(length - 1) != 'B') {
            invalidReason.append(SchemaMessages.WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED.get(value.stringValue()));
            return false;
        }
        block3: for (int i = 1; i < length - 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': {
                    continue block3;
                }
                default: {
                    invalidReason.append(SchemaMessages.WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT.get(value.stringValue(), String.valueOf(valueString.charAt(i))));
                    return false;
                }
            }
        }
        return true;
    }
}

