/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public class AuthPasswordEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "authPasswordMatch";
    }

    public String getOID() {
        return "1.3.6.1.4.1.4203.1.2.3";
    }

    public String getDescription() {
        return "authentication password matching rule";
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        byte[] currentValue = value.value();
        byte[] newValue = new byte[currentValue.length];
        System.arraycopy(currentValue, 0, newValue, 0, currentValue.length);
        return new ASN1OctetString(newValue);
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }

    public ConditionResult valuesMatch(ByteString attributeValue, ByteString assertionValue) {
        StringBuilder[] authPWComponents;
        try {
            authPWComponents = AuthPasswordSyntax.decodeAuthPassword(attributeValue.stringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.FALSE;
        }
        PasswordStorageScheme storageScheme = DirectoryServer.getAuthPasswordStorageScheme(authPWComponents[0].toString());
        if (storageScheme == null) {
            return ConditionResult.FALSE;
        }
        if (storageScheme.authPasswordMatches(assertionValue, authPWComponents[1].toString(), authPWComponents[2].toString())) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        return 1;
    }
}

