/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.RoutableMessage;

public class EntryMessage
extends RoutableMessage
implements Serializable {
    private static final long serialVersionUID = 6116955858351992926L;
    private byte[] entryByteArray;

    public EntryMessage(short sender, short destination, byte[] entryBytes) {
        super(sender, destination);
        this.entryByteArray = (byte[])entryBytes.clone();
    }

    public EntryMessage(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 12) {
                throw new DataFormatException("input is not a valid ServerStart msg");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String senderIDString = new String(in, pos, length, "UTF-8");
            this.senderID = Short.valueOf(senderIDString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String destinationString = new String(in, pos, length, "UTF-8");
            this.destination = Short.valueOf(destinationString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.entryByteArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                this.entryByteArray[i] = in[pos + i];
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public byte[] getEntryBytes() {
        return this.entryByteArray;
    }

    public byte[] getBytes() {
        try {
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] entryBytes = this.entryByteArray;
            int length = 1 + senderBytes.length + 1 + destinationBytes.length + 1 + entryBytes.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 12;
            int pos = 1;
            pos = this.addByteArray(senderBytes, resultByteArray, pos);
            pos = this.addByteArray(destinationBytes, resultByteArray, pos);
            pos = this.addByteArray(entryBytes, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

