/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttributeInfo;
import org.opends.server.replication.plugin.HistKey;
import org.opends.server.replication.plugin.ValueInfo;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrInfoMultiple
extends AttributeInfo {
    private ChangeNumber deleteTime;
    private ChangeNumber lastUpdateTime;
    private ArrayList<ValueInfo> valuesInfo;

    public AttrInfoMultiple(ChangeNumber deleteTime, ChangeNumber updateTime, ArrayList<ValueInfo> valuesInfo) {
        this.deleteTime = deleteTime;
        this.lastUpdateTime = updateTime;
        this.valuesInfo = valuesInfo == null ? new ArrayList() : valuesInfo;
    }

    public AttrInfoMultiple() {
        this.deleteTime = null;
        this.lastUpdateTime = null;
        this.valuesInfo = new ArrayList();
    }

    private ChangeNumber getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public ChangeNumber getDeleteTime() {
        return this.deleteTime;
    }

    AttrInfoMultiple duplicate() {
        AttrInfoMultiple dup = new AttrInfoMultiple(this.deleteTime, this.lastUpdateTime, this.valuesInfo);
        return dup;
    }

    protected void delete(ChangeNumber CN) {
        Iterator<ValueInfo> it = this.valuesInfo.iterator();
        while (it.hasNext()) {
            ValueInfo info = it.next();
            if (!CN.newerOrEquals(info.getValueUpdateTime())) continue;
            it.remove();
        }
        if (CN.newer(this.deleteTime)) {
            this.deleteTime = CN;
        }
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    protected void delete(AttributeValue val, ChangeNumber CN) {
        ValueInfo info = new ValueInfo(val, null, CN);
        this.valuesInfo.remove(info);
        this.valuesInfo.add(info);
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    protected void delete(LinkedHashSet<AttributeValue> values, ChangeNumber CN) {
        for (AttributeValue val : values) {
            ValueInfo info = new ValueInfo(val, null, CN);
            this.valuesInfo.remove(info);
            this.valuesInfo.add(info);
            if (!CN.newer(this.lastUpdateTime)) continue;
            this.lastUpdateTime = CN;
        }
    }

    protected void add(AttributeValue val, ChangeNumber CN) {
        ValueInfo info = new ValueInfo(val, CN, null);
        this.valuesInfo.remove(info);
        this.valuesInfo.add(info);
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    private void add(LinkedHashSet<AttributeValue> values, ChangeNumber CN) {
        for (AttributeValue val : values) {
            ValueInfo info = new ValueInfo(val, CN, null);
            this.valuesInfo.remove(info);
            this.valuesInfo.add(info);
            if (!CN.newer(this.lastUpdateTime)) continue;
            this.lastUpdateTime = CN;
        }
    }

    @Override
    public ArrayList<ValueInfo> getValuesInfo() {
        return this.valuesInfo;
    }

    @Override
    public boolean replayOperation(Iterator<Modification> modsIterator, ChangeNumber changeNumber, Entry modifiedEntry, Modification m) {
        Attribute modAttr = m.getAttribute();
        AttributeType type = modAttr.getAttributeType();
        if (ChangeNumber.compare(changeNumber, this.getLastUpdateTime()) <= 0) {
            switch (m.getModificationType()) {
                case DELETE: {
                    if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
                        modsIterator.remove();
                        break;
                    }
                    this.conflictDelete(changeNumber, type, m, modifiedEntry, modAttr);
                    break;
                }
                case ADD: {
                    this.conflictAdd(modsIterator, changeNumber, modAttr.getValues(), modAttr.getOptions());
                    break;
                }
                case REPLACE: {
                    if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
                        modsIterator.remove();
                        break;
                    }
                    LinkedHashSet<AttributeValue> addedValues = modAttr.getValues();
                    modAttr.setValues(new LinkedHashSet<AttributeValue>());
                    this.conflictDelete(changeNumber, type, m, modifiedEntry, modAttr);
                    LinkedHashSet<AttributeValue> keptValues = modAttr.getValues();
                    this.conflictAdd(modsIterator, changeNumber, addedValues, modAttr.getOptions());
                    keptValues.addAll(addedValues);
                    break;
                }
            }
            return true;
        }
        this.processLocalOrNonConflictModification(changeNumber, m);
        return false;
    }

    @Override
    public void processLocalOrNonConflictModification(ChangeNumber changeNumber, Modification mod) {
        Attribute modAttr = mod.getAttribute();
        AttributeType type = modAttr.getAttributeType();
        switch (mod.getModificationType()) {
            case DELETE: {
                if (modAttr.getValues().isEmpty()) {
                    this.delete(changeNumber);
                    break;
                }
                this.delete(modAttr.getValues(), changeNumber);
                break;
            }
            case ADD: {
                if (type.isSingleValue()) {
                    this.delete(changeNumber);
                }
                this.add(modAttr.getValues(), changeNumber);
                break;
            }
            case REPLACE: {
                this.delete(changeNumber);
                this.add(modAttr.getValues(), changeNumber);
                break;
            }
        }
    }

    private boolean conflictDelete(ChangeNumber changeNumber, AttributeType type, Modification m, Entry modifiedEntry, Attribute modAttr) {
        LinkedHashSet<AttributeValue> delValues = modAttr.getValues();
        if (delValues == null || delValues.isEmpty()) {
            m.setModificationType(ModificationType.REPLACE);
            LinkedHashSet<AttributeValue> replValues = new LinkedHashSet<AttributeValue>();
            Iterator<ValueInfo> it = this.getValuesInfo().iterator();
            while (it.hasNext()) {
                ValueInfo valInfo = it.next();
                if (changeNumber.older(valInfo.getValueUpdateTime()).booleanValue()) {
                    replValues.add(valInfo.getValue());
                    continue;
                }
                if (!changeNumber.newerOrEquals(valInfo.getValueDeleteTime())) continue;
                it.remove();
            }
            modAttr.setValues(replValues);
            if (changeNumber.newer(this.getDeleteTime())) {
                this.deleteTime = changeNumber;
            }
            if (changeNumber.newer(this.getLastUpdateTime())) {
                this.lastUpdateTime = changeNumber;
            }
        } else {
            ArrayList<ValueInfo> valuesInfo = this.getValuesInfo();
            Iterator delValIterator = delValues.iterator();
            while (delValIterator.hasNext()) {
                AttributeValue val = (AttributeValue)delValIterator.next();
                Boolean deleteIt = true;
                ValueInfo valInfo = new ValueInfo(val, null, changeNumber);
                int index = valuesInfo.indexOf(valInfo);
                if (index != -1) {
                    ValueInfo oldValInfo = valuesInfo.get(index);
                    if (changeNumber.newer(oldValInfo.getValueDeleteTime()) && changeNumber.newer(oldValInfo.getValueUpdateTime())) {
                        valuesInfo.remove(index);
                        valuesInfo.add(valInfo);
                    } else if (oldValInfo.isUpdate()) {
                        deleteIt = false;
                    }
                } else {
                    valuesInfo.add(valInfo);
                }
                modifiedEntry.getAttribute(type);
                if (deleteIt.booleanValue() && modifiedEntry.hasValue(type, modAttr.getOptions(), val)) continue;
                delValIterator.remove();
            }
            if (changeNumber.newer(this.getLastUpdateTime())) {
                this.lastUpdateTime = changeNumber;
            }
        }
        return true;
    }

    private boolean conflictAdd(Iterator modsIterator, ChangeNumber changeNumber, LinkedHashSet<AttributeValue> addValues, Set<String> options) {
        if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
            modsIterator.remove();
            return false;
        }
        Iterator valIterator = addValues.iterator();
        while (valIterator.hasNext()) {
            ValueInfo valInfo;
            AttributeValue addVal = (AttributeValue)valIterator.next();
            ArrayList<ValueInfo> valuesInfo = this.getValuesInfo();
            int index = valuesInfo.indexOf(valInfo = new ValueInfo(addVal, changeNumber, null));
            if (index == -1) {
                valuesInfo.add(valInfo);
                continue;
            }
            ValueInfo oldValueInfo = valuesInfo.get(index);
            if (oldValueInfo.isUpdate()) {
                if (changeNumber.newer(oldValueInfo.getValueUpdateTime())) {
                    valuesInfo.remove(index);
                    valuesInfo.add(valInfo);
                }
                valIterator.remove();
                continue;
            }
            if (changeNumber.newer(oldValueInfo.getValueDeleteTime())) {
                valuesInfo.remove(index);
                valuesInfo.add(valInfo);
                continue;
            }
            valIterator.remove();
        }
        if (addValues.isEmpty()) {
            modsIterator.remove();
        }
        if (changeNumber.newer(this.getLastUpdateTime())) {
            this.lastUpdateTime = changeNumber;
        }
        return true;
    }

    @Override
    public void load(HistKey histKey, AttributeValue value, ChangeNumber cn) {
        switch (histKey) {
            case ADD: {
                if (value == null) break;
                this.add(value, cn);
                break;
            }
            case DEL: {
                if (value == null) break;
                this.delete(value, cn);
                break;
            }
            case REPL: {
                this.delete(cn);
                if (value == null) break;
                this.add(value, cn);
                break;
            }
            case DELATTR: {
                this.delete(cn);
            }
        }
    }
}

